//******************************************************************************
//
// MIDITrail / MTColorPaletteCfgDlg
//
// J[pbgݒ_CAO
//
// Copyright (C) 2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#include "MTColorConf.h"
#include <map>


//******************************************************************************
// J[ݒ_CAONX
//******************************************************************************
class MTColorPaletteCfgDlg
{
public:

	//RXgN^^fXgN^
	MTColorPaletteCfgDlg(void);
	virtual ~MTColorPaletteCfgDlg(void);

	//J[pbgݒ
	void SetColorPalette(
				MTColorPalette* pColorPalette, 
				MTColorPalette* pDefaultColorPalette,
			 	unsigned long colorPaletteNo
			 );

	//J[pbg擾
	void GetColorPalette(MTColorPalette* pColorPalette);

	//\F_CAO܂ŐԂȂ
	int Show(HWND hParentWnd);

	//p[^ύXmF
	bool IsChanged();

private:

	//EBhEvV[Wp|C^
	static MTColorPaletteCfgDlg* m_pThis;

	//AvP[VCX^X
	HINSTANCE m_hInstance;

	//EBhEnh
	HWND m_hWnd;

	//J[{^XgFCh.1-16, BG/GL/CT, Start/End
	HWND m_hColorButtonList[SM_MAX_CH_NUM + 3 + 2];

	//J[eLXgXgFCh.1-16, BG/GL/CT, Start/End
	HWND m_hColorTextList[SM_MAX_CH_NUM + 3 + 2];

	//J[pbg
	MTColorPalette m_ColorPalette;
	MTColorPalette m_DefaultColorPalette;
	unsigned long m_ColorPaletteNo;
	D3DXCOLOR m_ColorStart;
	D3DXCOLOR m_ColorEnd;

	//FI_CAOpp[^
	COLORREF m_CustColors[16];

	//ύXtO
	bool m_isChanged;

	//J[p[^}bv
	typedef std::map<std::string, std::string> MTColorParamDictionary;
	typedef std::pair<std::string, std::string> MTColorParamDictionaryPair;

	//EBhEvV[W
	static INT_PTR CALLBACK _WndProc(HWND, UINT, WPARAM, LPARAM);
	INT_PTR _WndProcImpl(const HWND hWnd, const UINT message, const WPARAM wParam, const LPARAM lParam);

	//_CAO\O
	int _OnInitDlg(HWND hDlg);

	//J[{^Xg
	void _InitColorButtonList();

	//J[{^
	int _InitColorButtons();

	//J[eLXg
	int _InitColorText();

	//R{{bNX
	int _InitCombobox(HWND hCombobox, int selectedIndex);

	//J[{^
	int _OnBtnColor(unsigned long targetNo);

	//Of[Vc[FSet Gradation Colors {^
	int _OnBtnSetGradationColors();

	//p[^ZbgAbvc[FSet Default Colors {^
	int _OnBtnSetDefaultColors();

	//p[^ZbgAbvc[FExport Color Parameters {^
	int _OonBtnExportColorParameters();

	//p[^ZbgAbvc[FImport Color Parameters {^
	int _OnBtnImportColorParameters();

	//J[{^XV
	int _UpdateColorButtons();

	//J[{^`
	int _DrawColorButton(DRAWITEMSTRUCT* pDrawItem);

	//J[eLXgXV
	int _UpdateColorText();

	//J[擾
	int _GetCurColor(unsigned long targetNo, D3DXCOLOR* pColor);

	//J[ݒ
	int _SetCurColor(unsigned long targetNo, D3DXCOLOR color);

	//J[I_CAO\
	int _ShowChooseColorDlg(
				D3DXCOLOR color,
				D3DXCOLOR* pNewColor,
				bool* pIsChoosed
			);

	//Of[VJ[ݒ
	int _SetGradationColor(
				unsigned long chNoStart,
				unsigned long chNoEnd,
				D3DXCOLOR colorStart,
				D3DXCOLOR colorEnd
			);

	//o͗pp[^񐶐
	int _MakeColorParamForExport(TCHAR* pTextBuf, unsigned long bufSize);

	//p[^͏
	int _ImportColorParam(TCHAR* pParamString);

	//p[^}bv쐬
	int _MakeImportKeyValueMap(TCHAR* pParamString, MTColorParamDictionary* pParamDictionary);

	//p[^ǂݍ
	int _LoadParam(MTColorParamDictionary* pParamDictionary);

};


