//******************************************************************************
//
// MIDITrail / MTColorParamExportDlg
//
// J[p[^o̓_CAO
//
// Copyright (C) 2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "resource.h"
#include "YNBaseLib.h"
#include "MTColorParamExportDlg.h"

using namespace YNBaseLib;


//******************************************************************************
// EBhEvV[Wpp[^ݒ
//******************************************************************************
MTColorParamExportDlg* MTColorParamExportDlg::m_pThis = NULL;

//******************************************************************************
// RXgN^
//******************************************************************************
MTColorParamExportDlg::MTColorParamExportDlg(void)
{
	m_pThis = this;
	m_hInstance = NULL;
	m_hWnd = NULL;
	m_ParamString[0] = _T('\0');

	return;
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTColorParamExportDlg::~MTColorParamExportDlg(void)
{
	return;
}

//******************************************************************************
// p[^o^
//******************************************************************************
void MTColorParamExportDlg::SetParamString(TCHAR* pString)
{
	_tcscat_s(m_ParamString, MT_COLOR_PARAM_EXPORT_STRING_LENGTH_MAX, pString);
	return;
}

//******************************************************************************
// \
//******************************************************************************
int MTColorParamExportDlg::Show(
		HWND hParentWnd
	)
{
	int result = 0;
	INT_PTR dresult = 0;
	HINSTANCE hInstance = NULL;

	//AvP[VCX^Xnh擾
	hInstance = (HINSTANCE)(LONG_PTR)GetWindowLongPtr(hParentWnd, GWLP_HINSTANCE);
	if (hInstance == NULL) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD64)hParentWnd);
		goto EXIT;
	}

	//_CAO\
	dresult = DialogBox(
					hInstance,							//CX^Xnh
					MAKEINTRESOURCE(IDD_COLOR_PARAM_EXPORT),	//_CAO{bNXev[g
					hParentWnd,							//eEBhEnh
					_WndProc							//_CAO{bNXvV[W
				);
	if ((dresult == 0) || (dresult == -1)) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD64)hInstance);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// EBhEvV[W
//******************************************************************************
INT_PTR CALLBACK MTColorParamExportDlg::_WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	return m_pThis->_WndProcImpl(hWnd, message, wParam, lParam);
}

//******************************************************************************
// EBhEvV[WF
//******************************************************************************
INT_PTR MTColorParamExportDlg::_WndProcImpl(
		HWND hDlg,
		UINT message,
		WPARAM wParam,
		LPARAM lParam
	)
{
	int result = 0;
	LRESULT lresult = 0;

	UNREFERENCED_PARAMETER(lParam);

	switch (message) {
		case WM_INITDIALOG:
			result = _OnInitDlg(hDlg);
			if (result != 0) goto EXIT;
			break;
		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK) {
				EndDialog(hDlg, LOWORD(wParam));
			}
			else if (LOWORD(wParam) == IDCANCEL) {
				EndDialog(hDlg, LOWORD(wParam));
			}
			else if (LOWORD(wParam) == IDC_BTN_COPY) {
				result = _OnBtnCopy();
				if (result != 0) goto EXIT;
			}
			break;
		default:
			//ȂbZ[W
			break;
	}

EXIT:;
	if (result != 0) {
		YN_SHOW_ERR(hDlg);
	}
	return lresult;
}

//******************************************************************************
// _CAO\O
//******************************************************************************
int MTColorParamExportDlg::_OnInitDlg(HWND hDlg)
{
	int result = 0;
	BOOL bresult = FALSE;

	m_hWnd = hDlg;

	//p[^\
	bresult = SetWindowText(GetDlgItem(m_hWnd, IDC_EDIT_TEXT_EXPORT), m_ParamString);
	if (!bresult) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}
	
EXIT:;
	return result;
}

//******************************************************************************
// Rs[{^
//******************************************************************************
int MTColorParamExportDlg::_OnBtnCopy()
{
	int result = 0;
	BOOL bresult = FALSE;
	HANDLE hData = NULL;

	HGLOBAL hGlobalMemory;
	TCHAR* pGlobalMemory = NULL;

	//m
	hGlobalMemory = GlobalAlloc(GHND, MT_COLOR_PARAM_EXPORT_STRING_LENGTH_MAX);
	if (hGlobalMemory == NULL) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

	//bN
	pGlobalMemory = (LPSTR)GlobalLock(hGlobalMemory);
	if (pGlobalMemory == NULL) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

	//Ƀp[^
	_tcscat_s(pGlobalMemory, MT_COLOR_PARAM_EXPORT_STRING_LENGTH_MAX, m_ParamString);

	//bN
	bresult = GlobalUnlock(hGlobalMemory);
	if ((!bresult) && (GetLastError() != NO_ERROR)) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

	//Nbv{[hJ
	bresult = OpenClipboard(m_hWnd);
	if (!bresult) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

	//Nbv{[hNA
	bresult = EmptyClipboard();
	if (!bresult) {
		CloseClipboard();
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

	//Nbv{[hɃf[^o^
	hData = SetClipboardData(CF_TEXT, hGlobalMemory);
	if (hData == NULL) {
		CloseClipboard();
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

	//Nbv{[hւ̃f[^o^߃ǗOSɈp
	hGlobalMemory = NULL;

	//Nbv{[h
	bresult = CloseClipboard();
	if (!bresult) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

EXIT:;
	if (hGlobalMemory != NULL) {
		GlobalFree(hGlobalMemory);
	}
	return result;
}


