//******************************************************************************
//
// MIDITrail / MTFileList
//
// t@CXgNX
//
// Copyright (C) 2021-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "MTFileList.h"
#include "shlwapi.h"

using namespace YNBaseLib;


//******************************************************************************
// RXgN^
//******************************************************************************
MTFileList::MTFileList(void)
{
	m_TargetDirPath[0] = L'\0';
	m_CurFilePath[0] = L'\0';
	m_SelectedFileIndex = 0;
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTFileList::~MTFileList(void)
{
	Clear();
}

//******************************************************************************
// NA
//******************************************************************************
void MTFileList::Clear()
{
	m_TargetDirPath[0] = L'\0';
	m_CurFilePath[0] = L'\0';
	m_FileNameList.clear();
	m_SelectedFileIndex = 0;
}

//******************************************************************************
// fBNgzt@CXg쐬
//******************************************************************************
int MTFileList::MakeFileListWithDirectory(
		const WCHAR* pTargetDirPath,
		SMRcpConv* pRcpConv
	)
{
	int result = 0;
	WCHAR findPath[_MAX_PATH] = { L'\0' };
	WIN32_FIND_DATAW findData;
	HANDLE hFind = NULL;
	BOOL isFind = true;
	bool isMIDIDataFile = false;
	
	if (pTargetDirPath == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}
	
	if (wcslen(pTargetDirPath) > (_MAX_PATH - 1)) {
		result = YN_SET_ERR("Directory path is too long.", wcslen(pTargetDirPath), 0);
		goto EXIT;
	}
	
	Clear();
	
	//fBNgpXێ
	wcscpy_s(m_TargetDirPath, _MAX_PATH, pTargetDirPath);
	if (pTargetDirPath[wcslen(pTargetDirPath) - 1] != L'\\') {
		wcscat_s(m_TargetDirPath, _MAX_PATH, L"\\");
	}
	
	//t@CppX쐬
	findPath[0] = L'\0';
	wcscat_s(findPath, _MAX_PATH, m_TargetDirPath);
	wcscat_s(findPath, _MAX_PATH, L"*.*");

	//t@C
	hFind = FindFirstFileW(findPath, &findData);
	if (hFind == INVALID_HANDLE_VALUE) {
		//t@CȂ
		goto EXIT;
	}

	//t@CXg쐬
	while (isFind) {
		if (findData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
			//fBNg͖
		}
		else {
			//t@CgqmF
			isMIDIDataFile = false;
			if (YNPathUtil::IsFileExtMatch(findData.cFileName, L".mid")) {
				isMIDIDataFile = true;
			}
			else if (pRcpConv->IsAvailable() && pRcpConv->IsSupportFileExt(findData.cFileName)) {
				isMIDIDataFile = true;
			}
			if (isMIDIDataFile) {
				//t@CXgɒǉ
				m_FileNameList.push_back(findData.cFileName);
			}
		}
		//̃t@C
		isFind = FindNextFileW(hFind, &findData);
	}

	//t@C\[g
	m_FileNameList.sort();

EXIT:;
	if (hFind != NULL) FindClose(hFind);
	return result;
}

//******************************************************************************
// t@C擾
//******************************************************************************
size_t MTFileList::GetFileCount()
{
	return m_FileNameList.size();
}

//******************************************************************************
// t@CpX擾
//******************************************************************************
const WCHAR* MTFileList::GetFilePath(unsigned long index)
{
	WCHAR* pFilePath = NULL;
	MTFileNameList::iterator itr;

	if (m_FileNameList.size() <= index) {
		pFilePath = NULL;
	}
	else {
		itr = m_FileNameList.begin();
		advance(itr, index);
		m_CurFilePath[0] = L'\0';
		wcscat_s(m_CurFilePath, _MAX_PATH, m_TargetDirPath);
		wcscat_s(m_CurFilePath, _MAX_PATH, (*itr).c_str());
		pFilePath = &(m_CurFilePath[0]);
	}

	return pFilePath;
}

//******************************************************************************
// t@C擾
//******************************************************************************
const WCHAR* MTFileList::GetFileName(unsigned long index)
{
	const WCHAR* pFilePath = NULL;
	const WCHAR* pFileName = NULL;

	pFilePath = GetFilePath(index);
	if (pFilePath != NULL) {
		pFileName = PathFindFileNameW(pFilePath);
	}

	return pFileName;
}

//******************************************************************************
// It@Co^
//******************************************************************************
int MTFileList::SetSelectedFileName(const WCHAR* pFileName)
{
	int result = 0;
	unsigned long index = 0;
	MTFileNameList::iterator itr;

	if (pFileName == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	m_SelectedFileIndex = 0;

	//t@CXg猟i啶ʂȂj
	for (itr = m_FileNameList.begin(); itr != m_FileNameList.end(); itr++) {
		if (_wcsicmp((*itr).c_str(), pFileName) == 0) {
			m_SelectedFileIndex = index;
			break;
		}
		index++;
	}

EXIT:;
	return result;
}

//******************************************************************************
// 擪t@CI
//******************************************************************************
void MTFileList::SelectFirstFile()
{
	m_SelectedFileIndex = 0;
}

//******************************************************************************
// Ot@CI
//******************************************************************************
void MTFileList::SelectPreviousFile(bool* pIsExist)
{
	bool isExist = false;

	//t@C݂Ȃꍇ
	if (m_FileNameList.size() == 0) {
		//Ot@CȂŏI
	}
	//t@CXg擪I𒆂̏ꍇ
	else if (m_SelectedFileIndex == 0) {
		//Ot@CȂŏI
	}
	else {
		//Ot@CI
		m_SelectedFileIndex -= 1;
		isExist = true;
	}

	if (pIsExist != NULL) {
		*pIsExist = isExist;
	}

	return;
}

//******************************************************************************
// t@CI
//******************************************************************************
void MTFileList::SelectNextFile(bool* pIsExist)
{
	bool isExist = false;

	//t@C݂Ȃꍇ
	if (m_FileNameList.size() == 0) {
		//t@CȂŏI
	}
	//t@CXgI𒆂̏ꍇ
	else if (m_SelectedFileIndex >= (m_FileNameList.size() - 1)) {
		//t@CȂŏI
	}
	else {
		//t@CI
		m_SelectedFileIndex += 1;
		isExist = true;
	}
	
	if (pIsExist != NULL) {
		*pIsExist = isExist;
	}

	return;
}

//******************************************************************************
// 擪t@CI
//******************************************************************************
unsigned long MTFileList::GetSelectedFileIndex()
{
	return m_SelectedFileIndex;
}


