//******************************************************************************
//
// MIDITrail / MTFont2Bmp
//
// tHgrbg}bvϊNX
//
// Copyright (C) 2010-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// w蕶񂪏܂ꂽrbg}bv쐬B
// 1s̕ɂ̂ݑΉBs͑ΉĂȂB
// rbg}bṽTCY͉4̔{ɂȂ悤ɒB

#pragma once

#include <list>

//******************************************************************************
// p[^`
//******************************************************************************
//őrbg}bvTCYFeNX`摜ŋeʓIȍőTCY
#define MTFONT2BMP_MAX_BMP_WIDTH  (2048)

//******************************************************************************
// tHgrbg}bvϊNX
//******************************************************************************
class MTFont2Bmp
{
public:

	//RXgN^^fXgN^
	MTFont2Bmp(void);
	virtual ~MTFont2Bmp(void);

	//NA
	void Clear();
	
	//tHgݒ
	//  IɌŒsb`ɂꍇisForceFixedPitchtruew肷
	int SetFont(const WCHAR* pFontName, unsigned long fontSize, bool isForceFixedPitch = false);

	//rbg}bv쐬
	int CreateBmp(const WCHAR* pStr);
	
	//rbg}bvTCY擾
	void GetBmpSize(unsigned long* pHeight, unsigned long* pWidth);
	
	//rbg}bvsNZ擾
	//  K17i(0x00`0x10)̃sNZlԂ
	//  ͈͊Ow肷0xFFԂ
	BYTE GetBmpPixcel(unsigned long x, unsigned long y);

private:

	typedef struct {
		GLYPHMETRICS glyphMetric;
		unsigned long bmpHeight;
		unsigned long bmpWidth;
		unsigned char* pBmp;
	} MTGlyphBmp;

	typedef std::list<MTGlyphBmp> MTGlyphBmpList;

private:

	WCHAR m_FontName[LF_FACESIZE];
	unsigned long m_FontSize;
	bool m_isForceFixedPitch;

	HFONT m_hFont;
	TEXTMETRIC m_TextMetric;
	MTGlyphBmpList m_GlyphBmpList;

	BYTE* m_pBmpBuf;
	unsigned long m_BmpHeight;
	unsigned long m_BmpWidth;
	
	int _CreateLogFont();
	int _CreateGlyphBmp(WCHAR char1, WCHAR char2, bool isSurrogatePair, MTGlyphBmp* pGB);
	int _CreateGlyphBmpList(const WCHAR* pStr);
	int _CreateBmpBuf();
	int _WriteGlyphToBmpBuf();

};

