//******************************************************************************
//
// MIDITrail / MTTimeIndicator
//
// ^CCWP[^`NX
//
// Copyright (C) 2010-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "MTTimeIndicator.h"

using namespace YNBaseLib;


//******************************************************************************
// RXgN^
//******************************************************************************
MTTimeIndicator::MTTimeIndicator(void)
{
	m_CurPos = 0.0f;
	m_CurTickTime = 0;
	m_isEnableLine = false;
	m_isEnable = true;
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTTimeIndicator::~MTTimeIndicator(void)
{
	Release();
}

//******************************************************************************
// ^CCWP[^
//******************************************************************************
int MTTimeIndicator::Create(
		LPDIRECT3DDEVICE9 pD3DDevice,
		const TCHAR* pSceneName,
		SMSeqData* pSeqData
	)
{
	int result = 0;
	SMBarList barList;

	Release();

	//m[gfUCIuWFNg
	result = m_NoteDesign.Initialize(pSceneName, pSeqData);
	if (result != 0) goto EXIT;

	//v~eBu
	result = _CreatePrimitive(pD3DDevice);
	if (result != 0) goto EXIT;

	//v~eBuF^CC
	result = _CreatePrimitiveLine(pD3DDevice);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// v~eBu
//******************************************************************************
int MTTimeIndicator::_CreatePrimitive(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	unsigned long vertexNum = 0;
	unsigned long indexNum = 0;
	MTTIMEINDICATOR_VERTEX* pVertex = NULL;
	unsigned long* pIndex = NULL;

	//v~eBu
	result = m_Primitive.Initialize(
					sizeof(MTTIMEINDICATOR_VERTEX),	//_TCY
					_GetFVFFormat(),				//_FVFtH[}bg
					D3DPT_TRIANGLESTRIP				//v~eBu
				);
	if (result != 0) goto EXIT;

	//_obt@
	vertexNum = 4;
	result = m_Primitive.CreateVertexBuffer(pD3DDevice, vertexNum);
	if (result != 0) goto EXIT;

	//CfbNXobt@
	indexNum = 4;
	result = m_Primitive.CreateIndexBuffer(pD3DDevice, indexNum);
	if (result != 0) goto EXIT;

	//obt@̃bN
	result = m_Primitive.LockVertex((void**)&pVertex);
	if (result != 0) goto EXIT;
	result = m_Primitive.LockIndex(&pIndex);
	if (result != 0) goto EXIT;

	//obt@ɒ_ƃCfbNX
	result = _CreateVertexOfIndicator(pVertex, pIndex);
	if (result != 0) goto EXIT;

	//obt@̃bN
	result = m_Primitive.UnlockVertex();
	if (result != 0) goto EXIT;
	result = m_Primitive.UnlockIndex();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// v~eBu
//******************************************************************************
int MTTimeIndicator::_CreatePrimitiveLine(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	unsigned long vertexNum = 0;
	MTTIMEINDICATOR_VERTEX* pVertex = NULL;

	//v~eBu
	result = m_PrimitiveLine.Initialize(
					sizeof(MTTIMEINDICATOR_VERTEX),	//_TCY
					_GetFVFFormat(),				//_FVFtH[}bg
					D3DPT_LINELIST					//v~eBu
				);
	if (result != 0) goto EXIT;

	//_obt@
	vertexNum = 2;
	result = m_PrimitiveLine.CreateVertexBuffer(pD3DDevice, vertexNum);
	if (result != 0) goto EXIT;

	//obt@̃bN
	result = m_PrimitiveLine.LockVertex((void**)&pVertex);
	if (result != 0) goto EXIT;

	//obt@ɒ_ƃCfbNX
	result = _CreateVertexOfIndicatorLine(pVertex);
	if (result != 0) goto EXIT;

	//obt@̃bN
	result = m_PrimitiveLine.UnlockVertex();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// ړ
//******************************************************************************
int MTTimeIndicator::Transform(
		LPDIRECT3DDEVICE9 pD3DDevice,
		D3DXVECTOR3 camVector,
		float rollAngle
	)
{
	int result = 0;
	D3DXVECTOR3 moveVector;
	D3DXMATRIX rotateMatrix;
	D3DXMATRIX moveMatrix;
	D3DXMATRIX worldMatrix;

	//s񏉊
	D3DXMatrixIdentity(&rotateMatrix);
	D3DXMatrixIdentity(&moveMatrix);
	D3DXMatrixIdentity(&worldMatrix);

	//]s
	D3DXMatrixRotationX(&rotateMatrix, D3DXToRadian(rollAngle));

	//tʒu
	m_CurPos = m_NoteDesign.GetPlayPosX(m_CurTickTime);

	//ړs
	moveVector = m_NoteDesign.GetWorldMoveVector();
	D3DXMatrixTranslation(&moveMatrix, moveVector.x + m_CurPos, moveVector.y, moveVector.z);

	//s̍
	D3DXMatrixMultiply(&worldMatrix, &rotateMatrix, &moveMatrix);

	//ϊsݒ
	m_Primitive.Transform(worldMatrix);
	m_PrimitiveLine.Transform(worldMatrix);

	return result;
}

//******************************************************************************
// `
//******************************************************************************
int MTTimeIndicator::Draw(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;

	if (!m_isEnable) goto EXIT;

	//eNX`Xe[Wݒ
	//  J[ZF1gp  1FeNX`
	pD3DDevice->SetTextureStageState(0, D3DTSS_COLOROP,   D3DTOP_SELECTARG1);
	pD3DDevice->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
	// At@ZF1gp  1FeNX`
	pD3DDevice->SetTextureStageState(0, D3DTSS_ALPHAOP,   D3DTOP_SELECTARG1);
	pD3DDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);

	//eNX`tB^
	pD3DDevice->SetSamplerState(0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR);
	pD3DDevice->SetSamplerState(0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR);

	if (m_isEnableLine) {
		result = m_PrimitiveLine.Draw(pD3DDevice);
		if (result != 0) goto EXIT;
	}
	else {
		result = m_Primitive.Draw(pD3DDevice);
		if (result != 0) goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// 
//******************************************************************************
void MTTimeIndicator::Release()
{
	m_Primitive.Release();
	m_PrimitiveLine.Release();
}

//******************************************************************************
// ^CCWP[^_
//******************************************************************************
int MTTimeIndicator::_CreateVertexOfIndicator(
		MTTIMEINDICATOR_VERTEX* pVertex,
		unsigned long* pIndex
	)
{
	int result = 0;
	unsigned long i;
	D3DXVECTOR3 vectorLU;
	D3DXVECTOR3 vectorRU;
	D3DXVECTOR3 vectorLD;
	D3DXVECTOR3 vectorRD;
	float delta = 0.0f;

	//              y x
	//  0+----+1    |/
	//   |    |  z--+0
	//   |    |
	//  2+----+3  3 _(0,0,0)

	//Đʒ_W擾
	m_NoteDesign.GetPlaybackSectionVirtexPos(
			0,
			&vectorLU,
			&vectorRU,
			&vectorLD,
			&vectorRD
		);

	//_W
	pVertex[0].p = vectorLU;
	pVertex[1].p = vectorRU;
	pVertex[2].p = vectorLD;
	pVertex[3].p = vectorRD;

	//Đʂ̕[ɋ߂ꍇ̓C`悷
	delta = vectorLU.z - vectorRU.z;
	if (delta < 0) {
		delta = -1.0f * delta;
	}
	if (delta < 0.1) {
		m_isEnableLine = true;
	}

	//@
	pVertex[0].n = D3DXVECTOR3(-1.0f, 0.0f, 0.0f);
	pVertex[1].n = D3DXVECTOR3(-1.0f, 0.0f, 0.0f);
	pVertex[2].n = D3DXVECTOR3(-1.0f, 0.0f, 0.0f);
	pVertex[3].n = D3DXVECTOR3(-1.0f, 0.0f, 0.0f);

	//e_̃fBt[YF
	for (i = 0; i < 4; i++) {
		pVertex[i].c = m_NoteDesign.GetPlaybackSectionColor();
	}

	//CfbNXFTRIANGLESTRIP
	pIndex[0] = 0;
	pIndex[1] = 1;
	pIndex[2] = 2;
	pIndex[3] = 3;

	return result;
}

//******************************************************************************
// ^CCWP[^C_
//******************************************************************************
int MTTimeIndicator::_CreateVertexOfIndicatorLine(
		MTTIMEINDICATOR_VERTEX* pVertex
	)
{
	int result = 0;
	unsigned long i;
	D3DXVECTOR3 vectorLU;
	D3DXVECTOR3 vectorRU;
	D3DXVECTOR3 vectorLD;
	D3DXVECTOR3 vectorRD;

	//              y x
	//  0+----+1    |/
	//   |    |  z--+0
	//   |    |
	//  2+----+3  3 _(0,0,0)

	//Đʒ_W擾
	m_NoteDesign.GetPlaybackSectionVirtexPos(
			0,
			&vectorLU,
			&vectorRU,
			&vectorLD,
			&vectorRD
		);

	//_W
	pVertex[0].p = vectorLU;
	pVertex[1].p = vectorLD;

	//@
	pVertex[0].n = D3DXVECTOR3(0.0f, 0.0f, -1.0f);
	pVertex[1].n = D3DXVECTOR3(0.0f, 0.0f, -1.0f);

	//e_̃fBt[YF
	for (i = 0; i < 2; i++) {
		pVertex[i].c = m_NoteDesign.GetGridLineColor();
	}

	return result;
}

//******************************************************************************
// `bN^Cݒ
//******************************************************************************
void MTTimeIndicator::SetCurTickTime(
		unsigned long curTickTime
	)
{
	m_CurTickTime = curTickTime;
	m_CurPos = m_NoteDesign.GetPlayPosX(m_CurTickTime);
}

//******************************************************************************
// Zbg
//******************************************************************************
void MTTimeIndicator::Reset()
{
	m_CurTickTime = 0;
	m_CurPos = 0.0f;
}

//******************************************************************************
// ݈ʒu擾
//******************************************************************************
float MTTimeIndicator::GetPos()
{
	return m_CurPos;
}

//******************************************************************************
// ړxNg擾
//******************************************************************************
D3DXVECTOR3 MTTimeIndicator::GetMoveVector()
{
	return D3DXVECTOR3(m_CurPos, 0.0f, 0.0f);
}

//******************************************************************************
// \ݒ
//******************************************************************************
void MTTimeIndicator::SetEnable(
		bool isEnable
	)
{
	m_isEnable = isEnable;
}


