//******************************************************************************
//
// Simple MIDI Library / SMRcpConv
//
// RCPt@CϊNX
//
// Copyright (C) 2010-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// ӂ݂JĂ RCPCV.DLL(*1) pāAR|[U
// f[^t@C(*.rcp,*.r36,*.g36)WMIDIt@CɕϊB
// RCPCV.DLL AvP[VƓtH_ɑ݂Ƃɗp\ƂB
// RCPCV.DLL ݂ȂΖ{NX̋@\͗płȂB
// OIsAvailable()\bhpėpۂmF邱ƁB
//
// (*1) RCPCV.DLL
// http://www.vector.co.jp/soft/win95/art/se114143.html

#pragma once

#ifdef SMIDILIB_EXPORTS
#define SMIDILIB_API __declspec(dllexport)
#else
#define SMIDILIB_API __declspec(dllimport)
#endif

#include <windows.h>

namespace SMIDILib {

//******************************************************************************
// SysExCxgNX
//******************************************************************************
class SMIDILIB_API SMRcpConv
{
public:

	//RXgN^^fXgN^
	SMRcpConv();
	virtual ~SMRcpConv(void);

	//
	int Initialize();

	//p۔
	bool IsAvailable();

	//WMIDt@Cϊ
	int Convert(const WCHAR* pRCPPath, const WCHAR* pSMFPath);

	//gqɂT|[gΏۃt@C
	bool IsSupportFileExt(const WCHAR* pFilePath);

	//GetOpenFileNamept@CtB^擾
	const WCHAR* GetOpenFileNameFilter();

private:

	HMODULE m_hModule;

	//RCPCV.DLL API`
	typedef DWORD  (WINAPI *RCPCV_ConvertFile)(LPCSTR, UINT, DWORD, UINT, DWORD);
	typedef int    (WINAPI *RCPCV_SaveSMF)(DWORD, LPCSTR);
	typedef void   (WINAPI *RCPCV_DeleteObject)(DWORD);
	typedef DWORD  (WINAPI *RCPCV_ConvertFileFromBuffer)(LPCSTR, UINT, UINT, UINT, DWORD, UINT, DWORD);
	typedef LPCSTR (WINAPI *RCPCV_GetSMF)(DWORD);
	typedef int    (WINAPI *RCPCV_GetSMFLength)(DWORD);

	//֐|C^
	RCPCV_ConvertFile           m_pFuncConvertFile;
	RCPCV_SaveSMF               m_pFuncSaveSMF;
	RCPCV_DeleteObject          m_pFuncDeleteObject;
	RCPCV_ConvertFileFromBuffer m_pFuncConvertFileFromBuffer;
	RCPCV_GetSMF                m_pFuncGetSMF;
	RCPCV_GetSMFLength          m_pFuncGetSMFLength;

	void _Release();

};

} // end of namespace

