//******************************************************************************
//
// Simple Base Library / YNConfFile
//
// ݒt@CNX
//
// Copyright (C) 2010-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// INIt@Cւ̃ANZXbvNXB

#pragma once

#ifdef YNBASELIB_EXPORTS
#define YNBASELIB_API __declspec(dllexport)
#else
#define YNBASELIB_API __declspec(dllimport)
#endif

#include <stdlib.h>

namespace YNBaseLib {

//******************************************************************************
// ݒt@CNX
//******************************************************************************
class YNBASELIB_API YNConfFile
{
public:

	//RXgN^^fXgN^
	YNConfFile(void);
	virtual ~YNConfFile(void);

	//
	int Initialize(const TCHAR* pConfFilePath);

	//JgZNVݒ
	int SetCurSection(const TCHAR* pSection);

	//l擾^o^
	int GetInt(const TCHAR* pKey, int* pVal, int defaultVal);
	int SetInt(const TCHAR* pKey, int val);

	//l擾^o^
	int GetFloat(const TCHAR* pKey, float* pVal, float defaultVal);
	int SetFloat(const TCHAR* pKey, float val);

	//擾^o^
	int GetStr(const TCHAR* pKey, TCHAR* pBuf, unsigned long bufSize, const TCHAR* pDefaultVal);
	int SetStr(const TCHAR* pKey, const TCHAR* pStr);

	//擾^o^il̂݃Chj
	int GetWStr(const TCHAR* pKey, WCHAR* pBuf, unsigned long bufSize, const WCHAR* pDefaultVal);
	int SetWStr(const TCHAR* pKey, const WCHAR* pStr);

private:

	TCHAR m_FilePath[_MAX_PATH];
	TCHAR m_Section[_MAX_PATH];

	//ƃRs[RXgN^̋֎~
	void operator=(const YNConfFile&);
	YNConfFile(const YNConfFile&);

};


} // end of namespace

