//******************************************************************************
//
// MIDITrail / MTGamePadCtrl
//
// ゲームパッド制御クラス
//
// Copyright (C) 2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import <GameController/GameController.h>


//******************************************************************************
// パラメータ定義
//******************************************************************************

//ボタンON閾値(0.0-1.0)
#define MT_GAME_PAD_BUTTON_ON_THRESHOLD		(0.2)

//最大ユーザ数
#define MT_USER_MAX_COUNT		(4)


//******************************************************************************
// ゲームパッド制御クラス
//******************************************************************************
class MTGamePadCtrl
{
public:
	
	//コンストラクタ／デストラクタ
	MTGamePadCtrl(void);
	virtual ~MTGamePadCtrl();
	
	//初期化
	int Initialize(int userIndex);
	
	//コントローラー取得
	GCController* GetController();
	
	//状態更新
	int UpdateState();
	
	//ボタン状態取得
	bool GetState_DPadUp();
	bool GetState_DPadDown();
	bool GetState_DPadLeft();
	bool GetState_DPadRight();
	bool GetState_A();
	bool GetState_B();
	bool GetState_X();
	bool GetState_Y();
	bool GetState_LShoulder();
	bool GetState_RShoulder();
	bool GetState_LTrigger();
	bool GetState_RTrigger();
	
	//スティック状態取得(0.0 - 1.0)
	float GetState_ThumbLX();
	float GetState_ThumbLY();
	float GetState_ThumbRX();
	float GetState_ThumbRY();
	
	//ボタン押下確認
	bool DidPressNow_A();
	bool DidPressNow_B();
	bool DidPressNow_X();
	bool DidPressNow_Y();
	bool DidPressNow_LShoulder();
	bool DidPressNow_RShoulder();
	bool DidPressNow_LTrigger();
	bool DidPressNow_RTrigger();
	bool DidPressNow_Pause();
	
private:
	
	//ゲームパッド状態
	typedef struct {
		float dpadUp;
		float dpadDown;
		float dpadLeft;
		float dpadRight;
		float buttonA;
		float buttonB;
		float buttonX;
		float buttonY;
		float buttonLShoulder;
		float buttonRShoulder;
		float buttonLTrigger;
		float buttonRTrigger;
		float thumbLX;
		float thumbLY;
		float thumbRX;
		float thumbRY;
	} MT_GAMEPAD_STATE;
	
	//ゲームコントローラー制御
	GCController* m_pGameController;
	
	//ユーザインデックス
	int m_UserIndex;
	
	//ゲームパッド接続状態
	bool m_isConnected;
	
	//ゲームパッド状態
	MT_GAMEPAD_STATE m_PrevGamePadState;
	MT_GAMEPAD_STATE m_CurGamePadState;
	
	void _ClearControllerState();
	void _GetGamepadState(MT_GAMEPAD_STATE* pGamepadState);

};


