//******************************************************************************
//
// MIDITrail / MTMenuCtrl
//
// メニュー制御クラス
//
// Copyright (C) 2010-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import <Cocoa/Cocoa.h>


//相互参照のため先行宣言する
//ヘッダファイルは実装ファイルでインクルードする
class MIDITrailApp;

//******************************************************************************
// メニュー項目定義
//******************************************************************************
//メニュースタイル制御
#define MT_MENU_NUM  (45)

//メニュー項目種別
enum MTMenuItem {
	MenuOpenFile,
	MenuOpenFolder,
	MenuPreviousFile,
	MenuPreviousFileHidden,
	MenuNextFile,
	MenuPlay,
	MenuStop,
	MenuRepeat,
	MenuFolderPlayback,
	MenuSkipBack,
	MenuSkipForward,
	MenuPlaySpeedDown,
	MenuPlaySpeedUp,
	MenuStartMonitoring,
	MenuStopMonitoring,
	MenuPianoRoll3D,
	MenuPianoRoll2D,
	MenuPianoRollRain,
	MenuPianoRollRain2D,
	MenuPianoRollRing,
	MenuPianoKeyboard,
	MenuRipple,
	MenuPitchBend,
	MenuStars,
	MenuCounter,
	MenuBackgroundImage,
	MenuGridLine,
	MenuTimeIndicator,
	MenuResetViewpoint,
	MenuViewpoint2,
	MenuViewpoint3,
	MenuMyViewpoint1,
	MenuMyViewpoint2,
	MenuMyViewpoint3,
	MenuSaveMyViewpoint1,
	MenuSaveMyViewpoint2,
	MenuSaveMyViewpoint3,
	MenuWindowSize,
	MenuFullScreen,
	MenuMIDIOUT,
	MenuMIDIIN,
	MenuGraphic,
	MenuColor,
	MenuHowToView,
	MenuManual
};

//******************************************************************************
// メニュー制御クラス
//******************************************************************************
@interface MTMenuCtrl : NSObject {
	
	MIDITrailApp* m_pApp;
	
	IBOutlet NSMenuItem* m_pMenuOpen;
	IBOutlet NSMenuItem* m_pMenuOpenFolder;
	IBOutlet NSMenuItem* m_pMenuPreviousFile;
	IBOutlet NSMenuItem* m_pMenuPreviousFileHidden;
	IBOutlet NSMenuItem* m_pMenuNextFile;
	IBOutlet NSMenuItem* m_pMenuPlay;
	IBOutlet NSMenuItem* m_pMenuStop;
	IBOutlet NSMenuItem* m_pMenuRepeat;
	IBOutlet NSMenuItem* m_pMenuFolderPlayback;
	IBOutlet NSMenuItem* m_pMenuSkipBack;
	IBOutlet NSMenuItem* m_pMenuSkipForward;
	IBOutlet NSMenuItem* m_pMenuPlaySpeedDown;
	IBOutlet NSMenuItem* m_pMenuPlaySpeedUp;
	IBOutlet NSMenuItem* m_pMenuStartMonitoring;
	IBOutlet NSMenuItem* m_pMenuStopMonitoring;	
	IBOutlet NSMenuItem* m_pMenuPianoRoll3D;
	IBOutlet NSMenuItem* m_pMenuPianoRoll2D;
	IBOutlet NSMenuItem* m_pMenuPianoRollRain;
	IBOutlet NSMenuItem* m_pMenuPianoRollRain2D;
	IBOutlet NSMenuItem* m_pMenuPianoRollRing;
	IBOutlet NSMenuItem* m_pMenuPianoKeyboard;
	IBOutlet NSMenuItem* m_pMenuRipple;
	IBOutlet NSMenuItem* m_pMenuPitchBend;
	IBOutlet NSMenuItem* m_pMenuStars;
	IBOutlet NSMenuItem* m_pMenuCounter;
	IBOutlet NSMenuItem* m_pMenuBackgroundImage;
	IBOutlet NSMenuItem* m_pMenuGridLine;
	IBOutlet NSMenuItem* m_pMenuTimeIndicator;
	IBOutlet NSMenuItem* m_pMenuResetViewpoint;
	IBOutlet NSMenuItem* m_pMenuViewpoint2;
	IBOutlet NSMenuItem* m_pMenuViewpoint3;
	IBOutlet NSMenuItem* m_pMenuMyViewpoint1;
	IBOutlet NSMenuItem* m_pMenuMyViewpoint2;
	IBOutlet NSMenuItem* m_pMenuMyViewpoint3;
	IBOutlet NSMenuItem* m_pMenuSaveMyViewpoint1;
	IBOutlet NSMenuItem* m_pMenuSaveMyViewpoint2;
	IBOutlet NSMenuItem* m_pMenuSaveMyViewpoint3;
	IBOutlet NSMenuItem* m_pMenuWindowSize;
	IBOutlet NSMenuItem* m_pMenuFullScreen;
	IBOutlet NSMenuItem* m_pMenuMIDIOUT;
	IBOutlet NSMenuItem* m_pMenuMIDIIN;
	IBOutlet NSMenuItem* m_pMenuGraphic;
	IBOutlet NSMenuItem *m_pMenuColor;
	IBOutlet NSMenuItem* m_pMenuHowToView;
	IBOutlet NSMenuItem* m_pMenuManual;
	IBOutlet NSMenuItem* m_pMenuQuit;
	
}

//初期化
- (int)initialize:(MIDITrailApp*)pApp;

//Playメニュー実行
- (void)performActionPlay;

//Stopメニュー実行
- (void)performActionStop;

//Quitメニュー実行
- (void)performActionQuit;

//Skip Backメニュー実行
- (void)performActionSkipBack;

//Skip Forwardメニュー実行
- (void)performActionSkipForward;

//Speed Downメニュー実行
- (void)performActionPlaySpeedDown;

//Speed Upメニュー実行
- (void)performActionPlaySpeedUp;

//Start Monitorメニュー実行
- (void)performActionStartMonitoring;

//Sttop Monitorメニュー実行
- (void)performActionStopMonitoring;

//Reset Viewpointメニュー実行
- (void)performActionResetViewpoint;

//Viewpoint 2メニュー実行
- (void)performActionViewpoint2;

//Viewpoint 3メニュー実行
- (void)performActionViewpoint3;

//My Viewpoint 1メニュー実行
- (void)performActionMyViewpoint1;

//My Viewpoint 2メニュー実行
- (void)performActionMyViewpoint2;

//My Viewpoint 3メニュー実行
- (void)performActionMyViewpoint3;

//Save My Viewpoint 1メニュー実行
- (void)performActionSaveMyViewpoint1;

//Save My Viewpoint 2メニュー実行
- (void)performActionSaveMyViewpoint2;

//Save My Viewpoint 3メニュー実行
- (void)performActionSaveMyViewpoint3;

//メニュー活性状態設定
- (void)setEnabled:(BOOL)isEnable forItem:(MTMenuItem)item;

//メニューマーク設定
- (void)setMark:(BOOL)isON forItem:(MTMenuItem)item;

//メニューオブジェクト参照
- (NSMenuItem*)menuItemOf:(MTMenuItem)item;

//メニュー選択イベント
- (IBAction)onMenuAbout:(id)sender;
- (IBAction)onMenuOpen:(id)sender;
- (IBAction)onMenuOpenFolder:(id)sender;
- (IBAction)onMenuPreviousFile:(id)sender;
- (IBAction)onMenuNextFile:(id)sender;
- (IBAction)onMenuPlay:(id)sender;
- (IBAction)onMenuStop:(id)sender;
- (IBAction)onMenuRepeat:(id)sender;
- (IBAction)onMenuFolderPlayback:(id)sender;
- (IBAction)onMenuSkipBack:(id)sender;
- (IBAction)onMenuSkipForward:(id)sender;
- (IBAction)onMenuPlaySpeedDown:(id)sender;
- (IBAction)onMenuPlaySpeedUp:(id)sender;
- (IBAction)onMenuStartMonitoring:(id)sender;
- (IBAction)onMenuStopMonitoring:(id)sender;
- (IBAction)onMenuPianoRoll3D:(id)sender;
- (IBAction)onMenuPianoRoll2D:(id)sender;
- (IBAction)onMenuPianoRollRain:(id)sender;
- (IBAction)onMenuPianoRollRain2D:(id)sender;
- (IBAction)onMenuPianoRollRing:(id)sender;
- (IBAction)onMenuPianoKeyboard:(id)sender;
- (IBAction)onMenuRipple:(id)sender;
- (IBAction)onMenuPitchBend:(id)sender;
- (IBAction)onMenuStars:(id)sender;
- (IBAction)onMenuCounter:(id)sender;
- (IBAction)onMenuBackgroundImage:(id)sender;
- (IBAction)onMenuGridLine:(id)sender;
- (IBAction)onMenuTimeIndicator:(id)sender;
- (IBAction)onMenuResetViewpoint:(id)sender;
- (IBAction)onMenuViewpoint2:(id)sender;
- (IBAction)onMenuViewpoint3:(id)sender;
- (IBAction)onMenuMyViewpoint1:(id)sender;
- (IBAction)onMenuMyViewpoint2:(id)sender;
- (IBAction)onMenuMyViewpoint3:(id)sender;
- (IBAction)onMenuSaveMyViewpoint1:(id)sender;
- (IBAction)onMenuSaveMyViewpoint2:(id)sender;
- (IBAction)onMenuSaveMyViewpoint3:(id)sender;
- (IBAction)onMenuWindowSize:(id)sender;
- (IBAction)onMenuFullScreen:(id)sender;
- (IBAction)onMenuMIDIOUT:(id)sender;
- (IBAction)onMenuMIDIIN:(id)sender;
- (IBAction)onMenuGraphic:(id)sender;
- (IBAction)onMenuColor:(id)sender;
- (IBAction)onMenuHowToView:(id)sender;
- (IBAction)onMenuManual:(id)sender;

//ファイルドロップ実行
- (void)onDropFile:(NSString*)pPath;

//フォルダドロップ実行
- (void)onDropFolder:(NSString*)pPath;

@end


