//******************************************************************************
//
// OGL Utility / OGLDevice
//
// デバイスクラス
//
// Copyright (C) 2010-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import <MetalKit/MetalKit.h>
#import "OGLTypes.h"
#import "OGLShaders.h"


//******************************************************************************
// デバイスクラス
//******************************************************************************
class OGLDevice
{
public:
	
	//コンストラクタ／デストラクタ
	OGLDevice(void);
	virtual ~OGLDevice(void);
	
	//初期化
	int Initialize(id <MTLDevice> metalDevice);
	
	//破棄
	int Release();
	
	//Metalデバイス取得
	id <MTLDevice> GetMetalDevice();
	
	//サンプル数設定
	void SetSampleCount(NSUInteger count);
	
	//サンプル数取得
	NSUInteger GetSampleCount();
	
	//ビューポート設定
	void SetViewPort(OGLVIEWPORT viewPort);
	
	//ビューポート取得
	void GetViewPort(OGLVIEWPORT* pViewPort);
	
	//モデル行列設定
	void SetModelMatrix(simd::float4x4 matrix);
	
	//ビュー行列設定
	void SetViewMatrix(simd::float4x4 matrix);
	
	//ビュー行列取得
	simd::float4x4 GetViewMatrix();
	
	//プロジェクション行列設定
	void SetProjectionMatrix(simd::float4x4 matrix);
	
	//マテリアル設定
	void SetMaterial(OGLMaterial material);
	
	//ポイントサイズ設定
	void SetPointSize(float pointSize);
	
	//ライト有無設定
	void SetEnableLights(bool isEnable);
	
	//ディレクショナルライト0設定
	void SetLight0(OGLLight light);
	
	//ディレクショナルライト1設定
	void SetLight1(OGLLight light);
	
	//制御情報初期化
	void InitUniforms();
	
	//制御情報取得
	OGLUniforms GetUniforms();
	
	//コマンドエンコーダ設定
	void SetCurrentCommandEncoder(id <MTLRenderCommandEncoder> encoder);
	
	//コマンドエンコーダ取得
	id <MTLRenderCommandEncoder> GetCurrentCommandEncoder();
	
private:
	
	//Metalデバイス
	id <MTLDevice> m_MetalDevice;
	id <MTLRenderCommandEncoder> m_Encoder;
	
	//ビューパラメータ
	NSUInteger m_SampleCount;
	OGLVIEWPORT m_ViewPort;
	
	//制御情報
	float4x4 m_ModelMatrix;
	float4x4 m_ViewMatrix;
	float4x4 m_ProjectionMatrix;
	OGLMaterial m_Material;
	float m_PointSize;
	uint32 m_EnableLights;
	OGLLight m_Light0;
	OGLLight m_Light1;
	
};


