//******************************************************************************
//
// OGL Utility / OGLColorUtil
//
// カラーユーティリティクラス
//
// Copyright (C) 2010-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "OGLTypes.h"
#import <Foundation/NSString.h>


//******************************************************************************
// カラーユーティリティクラス
//******************************************************************************
class OGLColorUtil
{
public:
	
	//RGBA（16進数文字列）からの数値への変換
	static OGLCOLOR MakeColorFromHexRGBA(const NSString* pHexRGBA);
	
	//数値からRGBA（16進数文字列）への変換
	static NSString* MakeHexRGBAFromColor(OGLCOLOR color);
	
private:
	
	//コンストラクタ／デストラクタ
	OGLColorUtil(void);
	virtual ~OGLColorUtil(void);
	
	//代入とコピーコンストラクタの禁止
	void operator=(const OGLColorUtil&);
	OGLColorUtil(const OGLColorUtil&);

};


