//******************************************************************************
//
// OGL Utility / OGLH
//
// ヘルパ関数クラス
//
// Copyright (C) 2010-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "OGLTypes.h"


//******************************************************************************
// パラメータ定義
//******************************************************************************
//円周率：floatの有効桁数は10進数で7桁ほど
#define OGL_MATH_PI  (3.141592)


//******************************************************************************
// ヘルパ関数クラス
//******************************************************************************
class OGLH
{
public:
	
	//ベクトル正規化
	static OGLVECTOR3 Vec3Normalize(const OGLVECTOR3 vector);
	
	//ベクトル内積
	static OGLfloat Vec3Dot(const OGLVECTOR3 vector1, const OGLVECTOR3 vector2);
	
	//ベクトル外積
	static OGLVECTOR3 Vec3Cross(const OGLVECTOR3 vector1, const OGLVECTOR3 vector2);
	
	//ラジアン算出
	static float ToRadian(float degree);
	
	//角度算出
	static float ToDegree(float radian);
	
	//符号確認
	static float Sign(float value);
	
	//座標回転：YZ平面
	static OGLVECTOR3 RotateYZ(
			float centerY,
			float centerZ,
			OGLVECTOR3 p1,
			float angle
		);
	
};


