//******************************************************************************
//
// MIDITrail / MTDashboardLive
//
// ライブモニタ用ダッシュボード描画クラス
//
// Copyright (C) 2012-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// MIDI IN デイバイス名, ノート数 を表示する。

#import "SMIDILib.h"
#import "OGLUtil.h"
#import "MTStaticCaption.h"
#import "MTDynamicCaption.h"
#import "MTDeviceScreenInfo.h"


//******************************************************************************
// パラメータ定義
//******************************************************************************
//フォント設定
//  Windows ：フォントサイズ40 -> ビットマップサイズ縦40ピクセル (MS Gothic)
//  Mac OS X：フォントサイズ40 -> ビットマップサイズ縦50ピクセル (Monaco)
//  iOS     ：フォントサイズ40 -> ビットマップサイズ縦??ピクセル (Courier)
#define MTDASHBOARDLIVE_FONTNAME  @"Courier"
#define MTDASHBOARDLIVE_FONTSIZE  (40)

//カウンタキャプション文字列
#define MTDASHBOARDLIVE_COUNTER_CHARS  "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789:/%[] "

//カウンタキャプションサイズ
//   1234567890123456789012345678901  (31)
//  "NOTES:00000000 [MONITERING OFF]"
//  余裕をみて40にしておく
#define MTDASHBOARDLIVE_COUNTER_SIZE  (40)

//FPSキャプション文字列
#define MTDASHBOARDLIVE_FPS_CHARS  "FPS0123456789:. "

//FPSキャプションサイズ
//   12345678901234567890  (20)
//  "FPS:000.0"
#define MTDASHBOARDLIVE_FPS_SIZE  (16)

//枠サイズ（ピクセル）
#define MTDASHBOARDLIVE_FRAMESIZE  (5.0f)

//デフォルト表示拡大率
#define MTDASHBOARDLIVE_DEFAULT_MAGRATE  (0.45f)  //Windows版では0.5

//******************************************************************************
// ライブモニタ用ダッシュボード描画クラス
//******************************************************************************
class MTDashboardLive
{
public:
	
	//コンストラクタ／デストラクタ
	MTDashboardLive(void);
	virtual ~MTDashboardLive(void);
	
	//生成
	int Create(OGLDevice* pOGLDevice, NSString* pSceneName, CGRect viewBounds);
	
	//更新
	int Transform(OGLDevice* pOGLDevice, OGLVECTOR3 camVector);
	
	//描画
	int Draw(OGLDevice* pOGLDevice);
	
	//解放
	void Release();
	
	//モニタ状態登録
	void SetMonitoringStatus(bool isMonitoring);
	
	//ノートON登録
	void SetNoteOn();
	
	//リセット
	void Reset();
	
	//FPS登録
	void SetFPS(float fps);
	
	//表示設定
	void SetEnable(bool isEnable);
	void SetEnableFPS(bool isEnable);
	
	//MIDI IN デバイス名登録
	int SetMIDIINDeviceName(OGLDevice* pOGLDevice, NSString* pName);
	
private:
	
	CGRect m_ViewBounds;
	
	MTStaticCaption m_Title;
	float m_PosTitleX;
	float m_PosTitleY;
	
	MTDynamicCaption m_Counter;
	float m_PosCounterX;
	float m_PosCounterY;
	float m_CounterMag;
	
	MTDynamicCaption m_CounterFPS;
	float m_PosFPSX;
	float m_PosFPSY;
	
	bool m_isMonitoring;
	unsigned int m_NoteCount;
	float m_FPS;
	
	OGLCOLOR m_CaptionColor;
	
	//表示可否
	bool m_isEnable;
	bool m_isEnableFPS;
	
	//デバイススクリーン情報
	MTDeviceScreenInfo m_DeviceScreenInfo;
	
	int _GetCounterPos(float* pX, float* pY);
	int _GetCounterStr(char* pStr, unsigned int bufSize);
	int _GetCounterFPSPos(float* pX, float* pY);
	int _GetFPSStr(char* pStr, unsigned int bufSize);
	int _LoadConfFile(NSString* pSceneName);
	
};


