//******************************************************************************
//
// MIDITrail / MTHelpViewCtrl
//
// ヘルプ画面制御クラス
//
// Copyright (C) 2012-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "YNBaseLib.h"
#import "MTHelpViewCtrl.h"


//******************************************************************************
// プライベートメソッド定義
//******************************************************************************
@interface MTHelpViewCtrl ()

@end


@implementation MTHelpViewCtrl

//******************************************************************************
// 生成
//******************************************************************************
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        //ビュー設定
		self.title = @"Help";
		self.tabBarItem.image = [UIImage imageNamed:@"img/TabIcon_Help"];
    }
    return self;
}

//******************************************************************************
// ビュー登録完了
//******************************************************************************
- (void)viewDidLoad
{
	NSArray* pLanguages = nil;
	NSString* pLanguage = nil;
	NSString* pFileName = nil;
	NSString* pHtmlPath = nil;
	WKWebViewConfiguration* pWebConfiguration = nil;
	
    [super viewDidLoad];
	// Do any additional setup after loading the view.
	
	//Webビュー設定
	pWebConfiguration = [[WKWebViewConfiguration alloc] init];
	if (@available(iOS 10.0, *)) {
		pWebConfiguration.dataDetectorTypes = WKDataDetectorTypeNone; //データ検出なし（iOS 10以降で有効）
	}
	
	//Webビュー生成
	m_pWebView = [[WKWebView alloc] initWithFrame:m_pBaseView.frame configuration:pWebConfiguration];
	
	//Webビューをベースビューに貼り付ける
	m_pWebView.translatesAutoresizingMaskIntoConstraints = NO;
	[m_pBaseView addSubview:m_pWebView];
	
	//デリゲート設定：現状使用しない
	//m_pWebView.navigationDelegate = self;
	//m_pWebView.UIDelegate = self;
	
	//選択されている言語を取得
	pLanguages = [NSLocale preferredLanguages];
	pLanguage = [pLanguages objectAtIndex:0];
	
	//言語によってファイル名を切り替える
    //iOS9以降はpreferredLanguagesの返却値が"ja"から"ja-JP"に変わっている
    //if ([pLanguage isEqualToString:@"ja"]) {
    if ([pLanguage hasPrefix:@"ja"]) {
		pFileName = @"doc/HELP.ja.html";
	}
	else {
		pFileName = @"doc/HELP.en.html";
	}
	
	//HTMLファイルパス生成
	pHtmlPath = [NSString stringWithFormat:@"%@/%@", [YNPathUtil resourceDirPath], pFileName];
	
	//HTMLファイル表示
	[m_pWebView loadRequest:[NSURLRequest requestWithURL:[NSURL fileURLWithPath:pHtmlPath]]];
	
	return;
}

//******************************************************************************
// インターフェース自動回転確認
//******************************************************************************
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
	return YES;
}

//******************************************************************************
// インターフェース自動回転確認（iOS6以降）
//******************************************************************************
- (BOOL)shouldAutorotate
{
	//回転を許可する
	return YES;
}

//******************************************************************************
// インターフェース自動回転確認：回転方向（iOS6以降）
//******************************************************************************
- (NSUInteger)supportedInterfaceOrientations
{
	//全方向に対応する
	return UIInterfaceOrientationMaskAll;
}

//******************************************************************************
// ビュー表示
//******************************************************************************
- (void)viewWillAppear:(BOOL)animated
{
	return;
}

//******************************************************************************
// ビュー非表示
//******************************************************************************
- (void)viewWillDisappear:(BOOL)animated
{
	return;
}

//******************************************************************************
// レイアウト処理終了
//******************************************************************************
- (void)viewDidLayoutSubviews
{
	CGRect baseViewFrame;
	CGRect webViewFrame;
	
	baseViewFrame = m_pBaseView.frame;
	webViewFrame = CGRectMake(0, 0, baseViewFrame.size.width, baseViewFrame.size.height);
	m_pWebView.frame = webViewFrame;

	return;
}


@end

