//******************************************************************************
//
// MIDITrail / MTNavCtrl
//
// ナビゲーション制御クラス
//
// Copyright (C) 2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "MTNavCtrl.h"


//******************************************************************************
// プライベートメソッド定義
//******************************************************************************
@interface MTNavCtrl ()

@end


@implementation MTNavCtrl

//******************************************************************************
// ビュー登録完了
//******************************************************************************
- (void)viewDidLoad
{
	//ナビゲーションバー表示設定
	if (@available(iOS 13.0, *)) {
		UINavigationBarAppearance* pAppearance = nil;
		pAppearance = [[UINavigationBarAppearance alloc] init];
		[pAppearance configureWithOpaqueBackground];
		self.navigationBar.standardAppearance = pAppearance;
		self.navigationBar.scrollEdgeAppearance = pAppearance;
		self.navigationBar.compactAppearance = pAppearance;
	}
}

//******************************************************************************
// インターフェース自動回転確認（iOS6以降）
//******************************************************************************
- (BOOL)shouldAutorotate
{
	//回転を許可する
	return YES;
}

//******************************************************************************
// インターフェース自動回転確認：回転方向（iOS6以降）
//******************************************************************************
- (NSUInteger)supportedInterfaceOrientations
{
	//全方向に対応する
	return UIInterfaceOrientationMaskAll;
}

@end

