//******************************************************************************
//
// MIDITrail / MTScene
//
// MIDITrail シーン基底クラス
//
// Copyright (C) 2010-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "YNBaseLib.h"
#import "MTScene.h"


//******************************************************************************
// コンストラクタ
//******************************************************************************
MTScene::MTScene(void)
{
	m_isActive = true;
	m_pSceneParamDictionary = [[NSMutableDictionary alloc] init];
}

//******************************************************************************
// デストラクタ
//******************************************************************************
MTScene::~MTScene(void)
{
	[m_pSceneParamDictionary release];
}

//******************************************************************************
// 名称取得
//******************************************************************************
NSString* MTScene::GetName()
{
	return @"NO NAME";
}

//******************************************************************************
// 生成
//******************************************************************************
int MTScene::Create(
		UIView* pView,
		CGRect viewBounds,
		OGLDevice* pD3DDevice,
		SMSeqData* pSeqData
	)
{
	return 0;
}

//******************************************************************************
// 変換
//******************************************************************************
int MTScene::Transform(
		OGLDevice* pD3DDevice,
		OGLScene::CameraType type
	)
{
	return 0;
}

//******************************************************************************
// 描画
//******************************************************************************
int MTScene::Draw(
		OGLDevice* pD3DDevice,
		OGLScene::CameraType type
	)
{
	return 0;
}

//******************************************************************************
// 破棄
//******************************************************************************
void MTScene::Release()
{
	return;
}

//******************************************************************************
// ウィンドウクリックイベント受信
//******************************************************************************
int MTScene::OnWindowClicked(
		unsigned int button,
		unsigned int wParam,
		unsigned int lParam
	)
{
	return 0;
}

//******************************************************************************
//マウスホイールイベント受信
//******************************************************************************
int MTScene::OnScrollWheel(
		float deltaWheelX,
		float deltaWheelY,
		float deltaWheelZ
	)
{
	return 0;
}

//******************************************************************************
// 演奏開始イベント受信
//******************************************************************************
int MTScene::OnPlayStart()
{
	return 0;
}

//******************************************************************************
// 演奏終了イベント受信
//******************************************************************************
int MTScene::OnPlayEnd()
{
	return 0;
}

//******************************************************************************
// シーケンサメッセージ受信
//******************************************************************************
int MTScene::OnRecvSequencerMsg(
		unsigned int wParam,
		unsigned int lParam
	)
{
	return 0;
}

//******************************************************************************
// 巻き戻し
//******************************************************************************
int MTScene::Rewind()
{
	return 0;
}

//******************************************************************************
// デフォルト視点取得
//******************************************************************************
void MTScene::GetDefaultViewParam(
		MTViewParamMap* pParamMap
	)
{
	return;
}

//******************************************************************************
// 視点取得
//******************************************************************************
void MTScene::GetViewParam(
		MTViewParamMap* pParamMap
	)
{
	return;
}

//******************************************************************************
// 視点登録
//******************************************************************************
void MTScene::SetViewParam(
		MTViewParamMap* pParamMap
	)
{
	return;
}

//******************************************************************************
// 視点リセット
//******************************************************************************
void MTScene::ResetViewpoint()
{
}

//******************************************************************************
// 静的視点移動
//******************************************************************************
void MTScene::MoveToStaticViewpoint(
		unsigned int viewpointNo
	)
{
	return;
}

//******************************************************************************
// 表示効果設定
//******************************************************************************
void MTScene::SetEffect(
		MTScene::EffectType type,
		bool isEnable
	)
{
	return;
}

//******************************************************************************
// アクティブ状態設定
//******************************************************************************
void MTScene::SetActiveState(
		bool isActive
	)
{
	m_isActive = isActive;
}

//******************************************************************************
// 演奏速度設定
//******************************************************************************
void MTScene::SetPlaySpeedRatio(
		unsigned int ratio
	)
{
	return;
}

//******************************************************************************
// シーンパラメータ登録
//******************************************************************************
int MTScene::SetParam(
		NSString* pKey,
		NSString* pValue
	)
{
	int result = 0;
	
	[m_pSceneParamDictionary setObject:pValue forKey:pKey];
	
EXIT:;
	return result;
}

//******************************************************************************
// シーンパラメータ取得
//******************************************************************************
NSString* MTScene::GetParam(
		NSString* pKey
	)
{
	NSString* pValue = nil;
	
	pValue = [m_pSceneParamDictionary objectForKey:pKey];
	
	return pValue;
}

//******************************************************************************
// タッチイベント：開始
//******************************************************************************
void MTScene::OnTouchesBegan(NSSet* pTouches)
{
	return;
}

//******************************************************************************
// タッチイベント：移動
//******************************************************************************
void MTScene::OnTouchesMoved(NSSet* pTouches)
{
	return;
}

//******************************************************************************
// タッチイベント：終了
//******************************************************************************
void MTScene::OnTouchesEnd(NSSet* pTouches)
{
	return;
}

//******************************************************************************
// タッチイベント：キャンセル
//******************************************************************************
void MTScene::OnTouchesCanceled(NSSet* pTouches)
{
	return;
}

//******************************************************************************
// タッチ操作種別取得
//******************************************************************************
MTTouchCtrl::OperationType MTScene::GetCurOperationType()
{
	return MTTouchCtrl::OperationNone;
}

//******************************************************************************
// スクリーンロック
//******************************************************************************
void MTScene::LockScreen(bool isLocked)
{
    return;
}

//******************************************************************************
// スクリーン種別設定
//******************************************************************************
void MTScene::SetScreenType(ScreenType type)
{
	return;
}

//******************************************************************************
// デバイス方向設定
//******************************************************************************
void MTScene::SetDeviceDirection(OGLQuaternion quaternion)
{
	return;
}

//******************************************************************************
// FPS設定
//******************************************************************************
void MTScene::SetFPS(float fps)
{
	return;
}

//******************************************************************************
// ゲームコントローラー更新
//******************************************************************************
int MTScene::OnGameControllerChanged()
{
	return 0;
}

//******************************************************************************
// スクリーンゲームパッド登録
//******************************************************************************
void MTScene::SetScreenGamePadCtrl(MTScreenGamePadCtrl* pScreenGamePadCtrl)
{
	return;
}

