//******************************************************************************
//
// MIDITrail / MTScenePianoRollRainLive
//
// ライブモニタ用ピアノロールレインシーン描画クラス
//
// Copyright (C) 2012-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "OGLUtil.h"
#import "MTScene.h"
#import "MTFirstPersonCam.h"
#import "MTStars.h"
#import "MTPianoKeyboardCtrlLive.h"
#import "MTNoteRainLive.h"
#import "MTDashboardLive.h"
#import "MTNotePitchBend.h"
#import "MTTouchCtrl.h"
#import "MTBackgroundImage.h"
#import "MTConfFile.h"
#import "SMIDILib.h"


//******************************************************************************
// ピアノロールレインシーン描画クラス
//******************************************************************************
class MTScenePianoRollRainLive : public MTScene
{
public:
	
	//コンストラクタ／デストラクタ
	MTScenePianoRollRainLive(void);
	virtual ~MTScenePianoRollRainLive(void);
	
	//名称取得
	NSString* GetName();
	
	//生成
	virtual int Create(
			UIView* pView,
			CGRect viewBounds,
			OGLDevice* pOGLDevice,
			SMSeqData* pSeqData
		);
	
	//変換
	int Transform(OGLDevice* pOGLDevice, OGLScene::CameraType cameraType);
	
	//描画
	int Draw(OGLDevice* pOGLDevice, OGLScene::CameraType cameraType);
	
	//破棄
	void Release();
	
	//ウィンドウクリックイベント受信
	int OnWindowClicked(
			unsigned int button,
			unsigned int wParam,
			unsigned int lParam
		);
	
	//マウスホイールイベント受信
	int OnScrollWheel(
			float deltaWheelX,	//ホイール左右傾斜
			float deltaWheelY,	//ホイール回転
			float deltaWheelZ	//？
		);
	
	//演奏開始イベント受信
	int OnPlayStart();
	
	//演奏終了イベント受信
	int OnPlayEnd();
	
	//シーケンサメッセージ受信
	int OnRecvSequencerMsg(
			unsigned int wParam,
			unsigned int lParam
		);
	
	//巻き戻し
	int Rewind();
	
	//視点取得／登録
	void GetDefaultViewParam(MTViewParamMap* pParamMap);
	void GetViewParam(MTViewParamMap* pParamMap);
	void SetViewParam(MTViewParamMap* pParamMap);
	void MoveToStaticViewpoint(unsigned int viewpointNo);
	
	//視点リセット
	void ResetViewpoint();
	
	//エフェクト設定
	void SetEffect(MTScene::EffectType type, bool isEnable);
	
	//タッチイベント
	void OnTouchesBegan(NSSet* pTouches);
	void OnTouchesMoved(NSSet* pTouches);
	void OnTouchesEnd(NSSet* pTouches);
	void OnTouchesCanceled(NSSet* pTouches);
	
	//タッチ操作種別取得
	MTTouchCtrl::OperationType GetCurOperationType();
	
	//スクリーンロック
	void LockScreen(bool isLocked);
	
	//スクリーン種別設定
	void SetScreenType(ScreenType type);
	
	//デバイス方向設定
	void SetDeviceDirection(OGLQuaternion quaternion);
	
	//FPS設定
	void SetFPS(float fps);
	
	//ゲームコントローラー更新
	int OnGameControllerChanged();
	
	//スクリーンゲームパッド登録
	void SetScreenGamePadCtrl(MTScreenGamePadCtrl* pScreenGamePadCtrl);
	
protected:
	
	//ライト有無
	bool m_IsEnableLight;
	
	//シングルキーボードフラグ
	bool m_IsSingleKeyboard;
	
private:
	
	//ビュー
	UIView* m_pView;
	
	//ライト
	OGLDirLight m_DirLight;
	OGLDirLight m_DirLight2;
	
	//一人称カメラ
	MTFirstPersonCam m_FirstPersonCam;
	
	//描画オブジェクト
	MTStars m_Stars;
	MTPianoKeyboardCtrlLive m_PianoKeyboardCtrlLive;
	MTNoteRainLive m_NoteRainLive;
	MTNotePitchBend m_NotePitchBend;
	MTDashboardLive m_DashboardLive;
	MTBackgroundImage m_BackgroundImage;
	
	//マウス視線移動モード
	bool m_IsMouseCamMode;
	
	//自動回転モード
	bool m_IsAutoRollMode;
	
	//視点情報
	MTViewParamMap m_ViewParamMap;
	MTViewParamMap m_Viewpoint2;
	MTViewParamMap m_Viewpoint3;
	
	//MIDIデイバイス名更新フラグ
	bool m_IsUpdateMIDIINDeviceName;
	
	//タッチイベント制御
	MTTouchCtrl m_TouchCtrl;
	
	//スクリーン種別
	MTScene::ScreenType m_ScreenType;
	
	void _Reset();
	void _SetLightColor(OGLDirLight* pLight);
	void _SetLightColor2(OGLDirLight* pLight);
	int _LoadConf();
	int _LoadConfViewpoint(
				MTConfFile* pConfFile,
				unsigned int viewpointNo,
				MTScene::MTViewParamMap* pParamMap
			);
	
};

