//******************************************************************************
//
// MIDITrail / MTScreenGamePadCtrl
//
// スクリーンゲームパッド制御クラス
//
// Copyright (C) 2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************


//******************************************************************************
// パラメータ定義
//******************************************************************************

//ボタンON閾値(0.0-1.0)
#define MT_SCREEN_GAMEPAD_BUTTON_ON_THRESHOLD		(0.2)


//******************************************************************************
// スクリーンゲームパッド制御クラス
//******************************************************************************
class MTScreenGamePadCtrl
{
public:
	
	//コンストラクタ／デストラクタ
	MTScreenGamePadCtrl(void);
	virtual ~MTScreenGamePadCtrl();
	
	//初期化
	int Initialize();
	
	//状態更新
	int UpdateState();
	
	//ボタン状態取得
	bool GetState_DPadUp();
	bool GetState_DPadDown();
	bool GetState_DPadLeft();
	bool GetState_DPadRight();
	bool GetState_A();
	bool GetState_B();
	bool GetState_X();
	bool GetState_Y();
	bool GetState_LShoulder();
	bool GetState_RShoulder();
	bool GetState_LTrigger();
	bool GetState_RTrigger();
	
	//スティック状態取得(0.0 - 1.0)
	float GetState_ThumbLX();
	float GetState_ThumbLY();
	float GetState_ThumbRX();
	float GetState_ThumbRY();
	
	//ボタン押下確認
	bool DidPressNow_A();
	bool DidPressNow_B();
	bool DidPressNow_X();
	bool DidPressNow_Y();
	bool DidPressNow_LShoulder();
	bool DidPressNow_RShoulder();
	bool DidPressNow_LTrigger();
	bool DidPressNow_RTrigger();
	bool DidPressNow_Pause();
	
	//ゲームパッド状態設定
	void SetState_DPadUp(float value);
	void SetState_DPadDown(float value);
	void SetState_DPadLeft(float value);
	void SetState_DPadRight(float value);
	void SetState_A(float value);
	void SetState_B(float value);
	void SetState_X(float value);
	void SetState_Y(float value);
	void SetState_LShoulder(float value);
	void SetState_RShoulder(float value);
	void SetState_LTrigger(float value);
	void SetState_RTrigger(float value);
	void GetState_ThumbLX(float value);
	void GetState_ThumbLY(float value);
	void GetState_ThumbRX(float value);
	void GetState_ThumbRY(float value);
	
private:
	
	//ゲームパッド状態
	typedef struct {
		float dpadUp;
		float dpadDown;
		float dpadLeft;
		float dpadRight;
		float buttonA;
		float buttonB;
		float buttonX;
		float buttonY;
		float buttonLShoulder;
		float buttonRShoulder;
		float buttonLTrigger;
		float buttonRTrigger;
		float thumbLX;
		float thumbLY;
		float thumbRX;
		float thumbRY;
	} MT_SCREEN_GAMEPAD_STATE;
	
	//ゲームパッド接続状態
	bool m_isConnected;
	
	//ゲームパッド状態
	MT_SCREEN_GAMEPAD_STATE m_ScreenGamePadState;
	MT_SCREEN_GAMEPAD_STATE m_PrevGamePadState;
	MT_SCREEN_GAMEPAD_STATE m_CurGamePadState;
	
	void _ClearControllerState();
	void _GetGamepadState(MT_SCREEN_GAMEPAD_STATE* pGamepadState);

};


