//******************************************************************************
//
// MIDITrail / MTScreenGamePadCtrl
//
// スクリーンゲームパッド制御クラス
//
// Copyright (C) 2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "YNBaseLib.h"
#import "MTScreenGamePadCtrl.h"


//******************************************************************************
// コンストラクタ
//******************************************************************************
MTScreenGamePadCtrl::MTScreenGamePadCtrl(void)
{
	m_isConnected = false;
	_ClearControllerState();
}

//******************************************************************************
// デストラクタ
//******************************************************************************
MTScreenGamePadCtrl::~MTScreenGamePadCtrl(void)
{
}

//******************************************************************************
// 初期化
//******************************************************************************
int MTScreenGamePadCtrl::Initialize()
{
	int result = 0;
	
	m_isConnected = true;
	
	//コントローラー状態初期化
	_ClearControllerState();
	
	//コントローラ状態取得
	_GetGamepadState(&m_CurGamePadState);
	
EXIT:;
	return result;
}

//******************************************************************************
// ゲームパッド状態更新
//******************************************************************************
int MTScreenGamePadCtrl::UpdateState()
{
	int result = 0;
	
	//前回のゲームパッド状態を退避
	m_PrevGamePadState = m_CurGamePadState;
	
	//現在のゲームパッド状態を取得
	_GetGamepadState(&m_CurGamePadState);
	
EXIT:;
	return result;
}

//******************************************************************************
// コントローラー状態初期化
//******************************************************************************
void MTScreenGamePadCtrl::_ClearControllerState()
{
	memset(&m_ScreenGamePadState, 0, sizeof(MT_SCREEN_GAMEPAD_STATE));
	memset(&m_PrevGamePadState, 0, sizeof(MT_SCREEN_GAMEPAD_STATE));
	memset(&m_CurGamePadState, 0, sizeof(MT_SCREEN_GAMEPAD_STATE));
}

//******************************************************************************
// コントローラー状態取得
//******************************************************************************
void MTScreenGamePadCtrl::_GetGamepadState(MT_SCREEN_GAMEPAD_STATE* pGamepadState)
{
	//コントローラー状態初期化
	memset(pGamepadState, 0, sizeof(MT_SCREEN_GAMEPAD_STATE));
	
	//コントローラーが未接続なら終了
	if (!m_isConnected) goto EXIT;
	
	//スクリーンの状態をコピー
	*pGamepadState = m_ScreenGamePadState;
	
EXIT:;
	return;
}

//******************************************************************************
// ボタン状態取得：上
//******************************************************************************
bool MTScreenGamePadCtrl::GetState_DPadUp()
{
	bool state = false;
	
	if ((m_isConnected) && (m_CurGamePadState.dpadUp >= MT_SCREEN_GAMEPAD_BUTTON_ON_THRESHOLD)) {
		state = true;
	}
	
	return state;
}

//******************************************************************************
// ボタン状態取得：下
//******************************************************************************
bool MTScreenGamePadCtrl::GetState_DPadDown()
{
	bool state = false;
	
	if ((m_isConnected) && (m_CurGamePadState.dpadDown >= MT_SCREEN_GAMEPAD_BUTTON_ON_THRESHOLD)) {
		state = true;
	}
	
	return state;
}

//******************************************************************************
// ボタン状態取得：左
//******************************************************************************
bool MTScreenGamePadCtrl::GetState_DPadLeft()
{
	bool state = false;
	
	if ((m_isConnected) && (m_CurGamePadState.dpadLeft >= MT_SCREEN_GAMEPAD_BUTTON_ON_THRESHOLD)) {
		state = true;
	}
	
	return state;
}

//******************************************************************************
// ボタン状態取得：右
//******************************************************************************
bool MTScreenGamePadCtrl::GetState_DPadRight()
{
	bool state = false;
	
	if ((m_isConnected) && (m_CurGamePadState.dpadRight >= MT_SCREEN_GAMEPAD_BUTTON_ON_THRESHOLD)) {
		state = true;
	}
	
	return state;
}

//******************************************************************************
// ボタン状態取得：A
//******************************************************************************
bool MTScreenGamePadCtrl::GetState_A()
{
	bool state = false;
	
	if ((m_isConnected) && (m_CurGamePadState.buttonA >= MT_SCREEN_GAMEPAD_BUTTON_ON_THRESHOLD)) {
		state = true;
	}
	
	return state;
}

//******************************************************************************
// ボタン状態取得：B
//******************************************************************************
bool MTScreenGamePadCtrl::GetState_B()
{
	bool state = false;
	
	if ((m_isConnected) && (m_CurGamePadState.buttonB >= MT_SCREEN_GAMEPAD_BUTTON_ON_THRESHOLD)) {
		state = true;
	}
	
	return state;
}

//******************************************************************************
// ボタン状態取得：X
//******************************************************************************
bool MTScreenGamePadCtrl::GetState_X()
{
	bool state = false;
	
	if ((m_isConnected) && (m_CurGamePadState.buttonX >= MT_SCREEN_GAMEPAD_BUTTON_ON_THRESHOLD)) {
		state = true;
	}
	
	return state;
}

//******************************************************************************
// ボタン状態取得：Y
//******************************************************************************
bool MTScreenGamePadCtrl::GetState_Y()
{
	bool state = false;
	
	if ((m_isConnected) && (m_CurGamePadState.buttonY >= MT_SCREEN_GAMEPAD_BUTTON_ON_THRESHOLD)) {
		state = true;
	}
	
	return state;
}

//******************************************************************************
// ボタン状態取得：左ショルダー
//******************************************************************************
bool MTScreenGamePadCtrl::GetState_LShoulder()
{
	bool state = false;
	
	if ((m_isConnected) && (m_CurGamePadState.buttonLShoulder >= MT_SCREEN_GAMEPAD_BUTTON_ON_THRESHOLD)) {
		state = true;
	}
	
	return state;
}

//******************************************************************************
// ボタン状態取得：右ショルダー
//******************************************************************************
bool MTScreenGamePadCtrl::GetState_RShoulder()
{
	bool state = false;
	
	if ((m_isConnected) && (m_CurGamePadState.buttonRShoulder >= MT_SCREEN_GAMEPAD_BUTTON_ON_THRESHOLD)) {
		state = true;
	}
	
	return state;
}

//******************************************************************************
// ボタン状態取得：左トリガー
//******************************************************************************
bool MTScreenGamePadCtrl::GetState_LTrigger()
{
	bool state = false;
	
	if ((m_isConnected) && (m_CurGamePadState.buttonLTrigger >= MT_SCREEN_GAMEPAD_BUTTON_ON_THRESHOLD)) {
		state = true;
	}
	
	return state;
}

//******************************************************************************
// ボタン状態取得：右トリガー
//******************************************************************************
bool MTScreenGamePadCtrl::GetState_RTrigger()
{
	bool state = false;
	
	if ((m_isConnected) && (m_CurGamePadState.buttonRTrigger >= MT_SCREEN_GAMEPAD_BUTTON_ON_THRESHOLD)) {
		state = true;
	}
	
	return state;
}

//******************************************************************************
// スティック状態取得：左スティックX
//******************************************************************************
float MTScreenGamePadCtrl::GetState_ThumbLX()
{
	float state = 0.0f;
	
	if (m_isConnected) {
		state = m_CurGamePadState.thumbLX;
	}
	
	return state;
}

//******************************************************************************
// スティック状態取得：左スティックY
//******************************************************************************
float MTScreenGamePadCtrl::GetState_ThumbLY()
{
	float state = 0.0f;
	
	if (m_isConnected) {
		state = m_CurGamePadState.thumbLY;
	}
	
	return state;
}

//******************************************************************************
// スティック状態取得：右スティックX
//******************************************************************************
float MTScreenGamePadCtrl::GetState_ThumbRX()
{
	float state = 0.0f;
	
	if (m_isConnected) {
		state = m_CurGamePadState.thumbRX;
	}
	
	return state;
}

//******************************************************************************
// スティック状態取得：右スティックY
//******************************************************************************
float MTScreenGamePadCtrl::GetState_ThumbRY()
{
	float state = 0.0f;
	
	if (m_isConnected) {
		state = m_CurGamePadState.thumbRY;
	}
	
	return state;
}

//******************************************************************************
// ボタン押下確認：A
//******************************************************************************
bool MTScreenGamePadCtrl::DidPressNow_A()
{
	bool isNow = false;
	
	if (m_isConnected) {
		if ((m_PrevGamePadState.buttonA < MT_SCREEN_GAMEPAD_BUTTON_ON_THRESHOLD)
		 && (m_CurGamePadState.buttonA >= MT_SCREEN_GAMEPAD_BUTTON_ON_THRESHOLD)) {
			isNow = true;
		}
	}
	
	return isNow;
}

//******************************************************************************
// ボタン押下確認：B
//******************************************************************************
bool MTScreenGamePadCtrl::DidPressNow_B()
{
	bool isNow = false;
	
	if (m_isConnected) {
		if ((m_PrevGamePadState.buttonB < MT_SCREEN_GAMEPAD_BUTTON_ON_THRESHOLD)
		 && (m_CurGamePadState.buttonB >= MT_SCREEN_GAMEPAD_BUTTON_ON_THRESHOLD)) {
			isNow = true;
		}
	}
	
	return isNow;
}

//******************************************************************************
// ボタン押下確認：X
//******************************************************************************
bool MTScreenGamePadCtrl::DidPressNow_X()
{
	bool isNow = false;
	
	if (m_isConnected) {
		if ((m_PrevGamePadState.buttonX < MT_SCREEN_GAMEPAD_BUTTON_ON_THRESHOLD)
		 && (m_CurGamePadState.buttonX >= MT_SCREEN_GAMEPAD_BUTTON_ON_THRESHOLD)) {

			isNow = true;
		}
	}
	
	return isNow;
}

//******************************************************************************
// ボタン押下確認：Y
//******************************************************************************
bool MTScreenGamePadCtrl::DidPressNow_Y()
{
	bool isNow = false;
	
	if (m_isConnected) {
		if ((m_PrevGamePadState.buttonY < MT_SCREEN_GAMEPAD_BUTTON_ON_THRESHOLD)
		 && (m_CurGamePadState.buttonY >= MT_SCREEN_GAMEPAD_BUTTON_ON_THRESHOLD)) {
			isNow = true;
		}
	}
	
	return isNow;
}

//******************************************************************************
// ボタン押下確認：左ショルダー
//******************************************************************************
bool MTScreenGamePadCtrl::DidPressNow_LShoulder()
{
	bool isNow = false;
	
	if (m_isConnected) {
		if ((m_PrevGamePadState.buttonLShoulder < MT_SCREEN_GAMEPAD_BUTTON_ON_THRESHOLD)
		 && (m_CurGamePadState.buttonLShoulder >= MT_SCREEN_GAMEPAD_BUTTON_ON_THRESHOLD)) {
			isNow = true;
		}
	}
	
	return isNow;
}

//******************************************************************************
// ボタン押下確認：右ショルダー
//******************************************************************************
bool MTScreenGamePadCtrl::DidPressNow_RShoulder()
{
	bool isNow = false;
	
	if (m_isConnected) {
		if ((m_PrevGamePadState.buttonRShoulder < MT_SCREEN_GAMEPAD_BUTTON_ON_THRESHOLD)
		 && (m_CurGamePadState.buttonRShoulder >= MT_SCREEN_GAMEPAD_BUTTON_ON_THRESHOLD)) {
			isNow = true;
		}
	}
	
	return isNow;
}

//******************************************************************************
// ボタン押下確認：左トリガー
//******************************************************************************
bool MTScreenGamePadCtrl::DidPressNow_LTrigger()
{
	bool isNow = false;
	
	if (m_isConnected) {
		if ((m_PrevGamePadState.buttonLTrigger < MT_SCREEN_GAMEPAD_BUTTON_ON_THRESHOLD)
		 && (m_CurGamePadState.buttonLTrigger >= MT_SCREEN_GAMEPAD_BUTTON_ON_THRESHOLD)) {
			isNow = true;
		}
	}
	
	return isNow;
}

//******************************************************************************
// ボタン押下確認：右トリガー
//******************************************************************************
bool MTScreenGamePadCtrl::DidPressNow_RTrigger()
{
	bool isNow = false;
	
	if (m_isConnected) {
		if ((m_PrevGamePadState.buttonRTrigger < MT_SCREEN_GAMEPAD_BUTTON_ON_THRESHOLD)
		 && (m_CurGamePadState.buttonRTrigger >= MT_SCREEN_GAMEPAD_BUTTON_ON_THRESHOLD)) {
			isNow = true;
		}
	}
	
	return isNow;
}

//******************************************************************************
// ゲームパッド状態設定：ボタン上
//******************************************************************************
void MTScreenGamePadCtrl::SetState_DPadUp(float value)
{
	m_ScreenGamePadState.dpadUp = value;
}

//******************************************************************************
// ゲームパッド状態設定：ボタン下
//******************************************************************************
void MTScreenGamePadCtrl::SetState_DPadDown(float value)
{
	m_ScreenGamePadState.dpadDown = value;
}

//******************************************************************************
// ゲームパッド状態設定：ボタン左
//******************************************************************************
void MTScreenGamePadCtrl::SetState_DPadLeft(float value)
{
	m_ScreenGamePadState.dpadLeft = value;
}

//******************************************************************************
// ゲームパッド状態設定：ボタン右
//******************************************************************************
void MTScreenGamePadCtrl::SetState_DPadRight(float value)
{
	m_ScreenGamePadState.dpadRight = value;
}

//******************************************************************************
// ゲームパッド状態設定：ボタンA
//******************************************************************************
void MTScreenGamePadCtrl::SetState_A(float value)
{
	m_ScreenGamePadState.buttonA = value;
}

//******************************************************************************
// ゲームパッド状態設定：ボタンB
//******************************************************************************
void MTScreenGamePadCtrl::SetState_B(float value)
{
	m_ScreenGamePadState.buttonB = value;
}

//******************************************************************************
// ゲームパッド状態設定：ボタンX
//******************************************************************************
void MTScreenGamePadCtrl::SetState_X(float value)
{
	m_ScreenGamePadState.buttonX = value;
}

//******************************************************************************
// ゲームパッド状態設定：ボタンY
//******************************************************************************
void MTScreenGamePadCtrl::SetState_Y(float value)
{
	m_ScreenGamePadState.buttonY = value;
}

//******************************************************************************
// ゲームパッド状態設定：左ショルダー
//******************************************************************************
void MTScreenGamePadCtrl::SetState_LShoulder(float value)
{
	m_ScreenGamePadState.buttonLShoulder = value;
}

//******************************************************************************
// ゲームパッド状態設定：右ショルダー
//******************************************************************************
void MTScreenGamePadCtrl::SetState_RShoulder(float value)
{
	m_ScreenGamePadState.buttonRShoulder = value;
}

//******************************************************************************
// ゲームパッド状態設定：左トリガー
//******************************************************************************
void MTScreenGamePadCtrl::SetState_LTrigger(float value)
{
	m_ScreenGamePadState.buttonLTrigger = value;
}

//******************************************************************************
// ゲームパッド状態設定：右トリガー
//******************************************************************************
void MTScreenGamePadCtrl::SetState_RTrigger(float value)
{
	m_ScreenGamePadState.buttonRTrigger = value;
}

//******************************************************************************
// ゲームパッド状態設定：左スティックX
//******************************************************************************
void MTScreenGamePadCtrl::GetState_ThumbLX(float value)
{
	m_ScreenGamePadState.thumbLX = value;
}

//******************************************************************************
// ゲームパッド状態設定：左スティックY
//******************************************************************************
void MTScreenGamePadCtrl::GetState_ThumbLY(float value)
{
	m_ScreenGamePadState.thumbLY = value;
}

//******************************************************************************
// ゲームパッド状態設定：右スティックX
//******************************************************************************
void MTScreenGamePadCtrl::GetState_ThumbRX(float value)
{
	m_ScreenGamePadState.thumbRX = value;
}

//******************************************************************************
// ゲームパッド状態設定：右スティックY
//******************************************************************************
void MTScreenGamePadCtrl::GetState_ThumbRY(float value)
{
	m_ScreenGamePadState.thumbRY = value;
}

