//******************************************************************************
//
// MIDITrail / MTSettingChannelViewCtrl
//
// チャンネル選択ビュークラス
//
// Copyright (C) 2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "YNBaseLib.h"
#import "SMIDILib.h"
#import "MTSettingChannelViewCtrl.h"


//******************************************************************************
// プライベートメソッド定義
//******************************************************************************
@interface MTSettingChannelViewCtrl ()

//チャンネル番号セル作成
- (UITableViewCell*)makeChannelNoCellForIndexPath:(NSIndexPath*)indexPath;

@end


@implementation MTSettingChannelViewCtrl

//******************************************************************************
// 初期化
//******************************************************************************
- (id)init
{
	int result = 0;
	NSString* pNibName = nil;
	
	//ビュー生成
	if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPhone) {
		//iPhone / iPod touch
		pNibName = @"MTSettingChannelView_iPhone";
	}
	else {
		//iPad
		pNibName = @"MTSettingChannelView_iPad";
	}
	
    self = [super initWithNibName:pNibName bundle:nil];
	if (self == nil) {
		result = YN_SET_ERR(@"Program error.", 0, 0);
		goto EXIT;
	}
	
	//ビュー設定
	self.title = @"Channel";
	
	//選択チャンネル番号
	m_SelectedChNo = 0;
	
EXIT:;
	if (result != 0) YN_SHOW_ERR();
    return self;
}

//******************************************************************************
// 破棄
//******************************************************************************
- (void)dealloc
{
	[super dealloc];
}

//******************************************************************************
// 選択チャンネル番号登録
//******************************************************************************
- (void)setSelectedChNo:(unsigned int)chNo
{
	m_SelectedChNo = chNo;
}

//******************************************************************************
// 選択チャンネル番号取得
//******************************************************************************
- (unsigned int)getSelectedChNo
{
	return m_SelectedChNo;
}

//******************************************************************************
// ビュー登録完了
//******************************************************************************
- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view.
	
	return;
}

//******************************************************************************
// インターフェース自動回転確認
//******************************************************************************
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    return YES;
}

//******************************************************************************
// インターフェース自動回転確認（iOS6以降）
//******************************************************************************
- (BOOL)shouldAutorotate
{
	//回転を許可する
	return YES;
}

//******************************************************************************
// インターフェース自動回転確認：回転方向（iOS6以降）
//******************************************************************************
- (NSUInteger)supportedInterfaceOrientations
{
	//全方向に対応する
	return UIInterfaceOrientationMaskAll;
}

//******************************************************************************
// ビュー表示
//******************************************************************************
- (void)viewWillAppear:(BOOL)animated
{	
	return;
}

//******************************************************************************
// ビュー非表示
//******************************************************************************
- (void)viewWillDisappear:(BOOL)animated
{
	return;
}

//******************************************************************************
// セクション数
//******************************************************************************
-(NSInteger)numberOfSectionsInTableView:(UITableView*)tableView
{
    return 1;
} 

//******************************************************************************
// セクションヘッダ
//******************************************************************************
- (NSString*)tableView:(UITableView*)tableView titleForHeaderInSection:(NSInteger)section
{
    return nil;
} 

//******************************************************************************
// セクションごとの項目数
//******************************************************************************
- (NSInteger)tableView:(UITableView *)tableView
 numberOfRowsInSection:(NSInteger)section
{
	NSInteger numOfRows = 0;
	
	switch (section) {
		case 0:
			numOfRows = SM_MAX_CH_NUM;
			break;
		default:
			break;
	}
	
	return numOfRows;
}

//******************************************************************************
// 項目表示内容
//******************************************************************************
- (UITableViewCell*)tableView:(UITableView*)tableView
		cellForRowAtIndexPath:(NSIndexPath*)indexPath
{
	UITableViewCell* pCell = nil;
	
	switch (indexPath.section) {
		case 0:
			//チャンネル番号一覧
			pCell = [self makeChannelNoCellForIndexPath:indexPath];
			break;
		default:
			break;
	}
	
	return pCell;
}

//******************************************************************************
// チャンネル番号セル作成
//******************************************************************************
- (UITableViewCell*)makeChannelNoCellForIndexPath:(NSIndexPath*)indexPath
{
    static NSString* pCellIdentifier = @"MTSettingChannelViewCtrl";
	UITableViewCell* pCell = nil;
	unsigned int index = 0;
	
	//再利用可能セル生成
	pCell = [m_pTableView dequeueReusableCellWithIdentifier:pCellIdentifier];
	if (pCell == nil) {
		pCell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
									   reuseIdentifier:pCellIdentifier];
	}
	
	//ラベル設定
	index = (unsigned int)indexPath.row;
	pCell.textLabel.text = [NSString stringWithFormat:@"Ch.%u", index + 1];
	
	//チェックマーク設定
	pCell.accessoryType = UITableViewCellAccessoryNone;
	if (index == m_SelectedChNo) {
		pCell.accessoryType = UITableViewCellAccessoryCheckmark;
	}
	
EXIT:;
	return pCell;
}

//******************************************************************************
// テーブルセル選択イベント
//******************************************************************************
- (void)tableView:(UITableView*)tableView didSelectRowAtIndexPath:(NSIndexPath*)indexPath
{
	unsigned int index = 0;
	
	//選択状態解除
	[tableView deselectRowAtIndexPath:indexPath animated:YES];
	
	switch (indexPath.section) {
		case 0:
			//チャンネル番号一覧
			index = (unsigned int)indexPath.row;
			m_SelectedChNo = index;
			break;
		default:
			break;
	}
	
	//再表示
	[tableView performSelector:@selector(reloadData) withObject:nil afterDelay:0.1f];
	
	return;
}

@end

