//******************************************************************************
//
// MIDITrail / MTSettingColorPaletteViewCtrl
//
// カラーパレット設定ビュークラス
//
// Copyright (C) 2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "MTColorConf.h"
#import "MTSettingChannelViewCtrl.h"
#import "MTSettingColorParamExportViewCtrl.h"
#import "MTSettingColorParamImportViewCtrl.h"


//******************************************************************************
// カラー設定ビュー制御クラス
//******************************************************************************
@interface MTSettingColorPaletteViewCtrl : UIViewController <UIDocumentPickerDelegate> {
	
	//テーブルビュー
	IBOutlet UITableView* m_pTableView;
	
	//カラーウェルタイトルリスト
	NSString* m_pColorWellTitleList[SM_MAX_CH_NUM + 3];
	
	//カラーパレット
	MTColorPalette m_DefaultColorPalette;
	MTColorPalette m_ColorPalette;
	unsigned int m_ColorPaletteNo;
	
	//カラーパレット変更通知名称
	NSString* m_pNotificationNameForChangedColorPalette;
	
	//グラデーションツール
	unsigned int m_GradationChNoStart;
	unsigned int m_GradationChNoEnd;
	OGLCOLOR m_GradationColorStart;
	OGLCOLOR m_GradationColorEnd;
	MTSettingChannelViewCtrl* m_pGradationChNoStartViewCtrl;
	MTSettingChannelViewCtrl* m_pGradationChNoEndViewCtrl;
	
	//パラメータセットアップツール
	MTSettingColorParamExportViewCtrl* m_pSettingColorParamExportViewCtrl;
	MTSettingColorParamImportViewCtrl* m_pSettingColorParamImportViewCtrl;
	
}

//生成
- (id)init;
//破棄
- (void)dealloc;

//カラーパレット設定
- (void)setColorPalette:(MTColorPalette*)pColorPalette
	defaultColorPalette:(MTColorPalette*)pDefaultColorPalette
		 colorPaletteNo:(unsigned int)colorPaletteNo;

//カラーパレット取得
- (void)getColorPalette:(MTColorPalette*)pColorPalette;

//カラーパレット番号取得
- (unsigned int)getColorPaletteNo;

//カラーパレット変更通知名称設定
- (void)setNotificationNameForChangedColorPalette:(NSString*)pNotificationName;

//ビュー登録完了
- (void)viewDidLoad;

//インターフェース自動回転確認
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation;

//インターフェース自動回転確認（iOS6以降）
- (BOOL)shouldAutorotate;
- (NSUInteger)supportedInterfaceOrientations;

//ビュー表示
- (void)viewWillAppear:(BOOL)animated;

//ビュー非表示
- (void)viewWillDisappear:(BOOL)animated;

//セクション数
-(NSInteger)numberOfSectionsInTableView:(UITableView*)tableView;

//セクションヘッダ
- (NSString*)tableView:(UITableView*)tableView titleForHeaderInSection:(NSInteger)section;

//セクションごとの項目数
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section;

//項目表示内容
- (UITableViewCell*)tableView:(UITableView*)tableView cellForRowAtIndexPath:(NSIndexPath*)indexPath;

//テーブルセル選択イベント
- (void)tableView:(UITableView*)tableView didSelectRowAtIndexPath:(NSIndexPath*)indexPath;


@end

