//******************************************************************************
//
// MIDITrail / MTSettingColorParamExportViewCtrl
//
// カラーパラメータ出力ビュークラス
//
// Copyright (C) 2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "YNBaseLib.h"
#import "MTSettingColorParamExportViewCtrl.h"


//******************************************************************************
// プライベートメソッド定義
//******************************************************************************
@interface MTSettingColorParamExportViewCtrl ()

//Copyボタン選択イベント
- (void)onCopyButton:(id)sender;

@end


@implementation MTSettingColorParamExportViewCtrl

//******************************************************************************
// 初期化
//******************************************************************************
- (id)init
{
	int result = 0;
	NSString* pNibName = nil;
	
	//ビュー生成
	if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPhone) {
		//iPhone / iPod touch
		pNibName = @"MTSettingColorParamExportView_iPhone";
	}
	else {
		//iPad
		pNibName = @"MTSettingColorParamExportView_iPad";
	}
	
    self = [super initWithNibName:pNibName bundle:nil];
	if (self == nil) {
		result = YN_SET_ERR(@"Program error.", 0, 0);
		goto EXIT;
	}
	
	//ビュー設定
	self.title = @"Export Color Parameters";
	
	//パラメータテキスト
	m_pParamText = nil;
	
EXIT:;
	if (result != 0) YN_SHOW_ERR();
    return self;
}

//******************************************************************************
// 破棄
//******************************************************************************
- (void)dealloc
{
	[m_pParamText release];
	[super dealloc];
}

//******************************************************************************
// パラメータ文字列登録
//******************************************************************************
- (void)setParamString:(NSString*)pString
{
	[m_pParamText release];
	m_pParamText = pString;
	[m_pParamText retain];
}

//******************************************************************************
// ビュー登録完了
//******************************************************************************
- (void)viewDidLoad
{
	UIBarButtonItem* pCopyButton = nil;
	
    [super viewDidLoad];
	// Do any additional setup after loading the view.
	
	//ナビゲーションバー右側にCopyボタンを配置
	pCopyButton = [[UIBarButtonItem alloc] initWithTitle:@"Copy"
												   style:UIBarButtonItemStylePlain
												  target:self
												  action:@selector(onCopyButton:)];
	self.navigationItem.rightBarButtonItem = pCopyButton;
	
	return;
}

//******************************************************************************
// インターフェース自動回転確認
//******************************************************************************
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    return YES;
}

//******************************************************************************
// インターフェース自動回転確認（iOS6以降）
//******************************************************************************
- (BOOL)shouldAutorotate
{
	//回転を許可する
	return YES;
}

//******************************************************************************
// インターフェース自動回転確認：回転方向（iOS6以降）
//******************************************************************************
- (NSUInteger)supportedInterfaceOrientations
{
	//全方向に対応する
	return UIInterfaceOrientationMaskAll;
}

//******************************************************************************
// ビュー表示
//******************************************************************************
- (void)viewWillAppear:(BOOL)animated
{
	m_pTextView.text = m_pParamText;
	return;
}

//******************************************************************************
// ビュー非表示
//******************************************************************************
- (void)viewWillDisappear:(BOOL)animated
{
	return;
}

//******************************************************************************
// Copyボタン選択イベント
//******************************************************************************
- (void)onCopyButton:(id)sender
{
	//ペーストボード（クリップボード）にパラメータ文字列を登録
	[UIPasteboard generalPasteboard].string = m_pParamText;
	
	return;
}

@end

