//******************************************************************************
//
// MIDITrail / MTSettingColorParamImportViewCtrl
//
// カラーパラメータ入力ビュークラス
//
// Copyright (C) 2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************


//******************************************************************************
// カラーパラメータ入力ビュークラス
//******************************************************************************
@interface MTSettingColorParamImportViewCtrl : UIViewController {
	
	//テキストビュー
	IBOutlet UITextView* m_pTextView;
	
	//パラメータインポート処理実行通知名称
	NSString* m_pNotificationNameForImportParam;
	
}

//生成
- (id)init;

//破棄
- (void)dealloc;

//インポート処理実行通知名称設定
- (void)setNotificationNameForImportParam:(NSString*)pNotificationName;

//ビュー登録完了
- (void)viewDidLoad;

//インターフェース自動回転確認
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation;

//インターフェース自動回転確認（iOS6以降）
- (BOOL)shouldAutorotate;
- (NSUInteger)supportedInterfaceOrientations;

//ビュー表示
- (void)viewWillAppear:(BOOL)animated;

//ビュー非表示
- (void)viewWillDisappear:(BOOL)animated;

//パラメータ文字列取得
- (NSString*)getParamString;

@end

