//******************************************************************************
//
// MIDITrail / MTSettingColorParamImportViewCtrl
//
// カラーパラメータ入力ビュークラス
//
// Copyright (C) 2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "YNBaseLib.h"
#import "MTSettingColorParamImportViewCtrl.h"


//******************************************************************************
// プライベートメソッド定義
//******************************************************************************
@interface MTSettingColorParamImportViewCtrl ()

//Importボタン選択イベント
- (void)onImportButton:(id)sender;

//通知送信処理
- (int)postNotificationWithName:(NSString*)pName;

@end


@implementation MTSettingColorParamImportViewCtrl

//******************************************************************************
// 初期化
//******************************************************************************
- (id)init
{
	int result = 0;
	NSString* pNibName = nil;
	
	//ビュー生成
	if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPhone) {
		//iPhone / iPod touch
		pNibName = @"MTSettingColorParamImportView_iPhone";
	}
	else {
		//iPad
		pNibName = @"MTSettingColorParamImportView_iPad";
	}
	
    self = [super initWithNibName:pNibName bundle:nil];
	if (self == nil) {
		result = YN_SET_ERR(@"Program error.", 0, 0);
		goto EXIT;
	}
	
	//ビュー設定
	self.title = @"Import Color Parameters";
	
	//パラメータインポート処理実行通知名称
	m_pNotificationNameForImportParam = nil;
	
EXIT:;
	if (result != 0) YN_SHOW_ERR();
    return self;
}

//******************************************************************************
// 破棄
//******************************************************************************
- (void)dealloc
{
	[m_pNotificationNameForImportParam release];
	[super dealloc];
}

//******************************************************************************
// パラメータインポート処理実行通知名称設定
//******************************************************************************
- (void)setNotificationNameForImportParam:(NSString*)pNotificationName
{
	[m_pNotificationNameForImportParam release];
	m_pNotificationNameForImportParam = pNotificationName;
	[m_pNotificationNameForImportParam retain];
}

//******************************************************************************
// ビュー登録完了
//******************************************************************************
- (void)viewDidLoad
{
	UIBarButtonItem* pImportButton = nil;
	
    [super viewDidLoad];
	// Do any additional setup after loading the view.
	
	//ナビゲーションバー右側にImportボタンを配置
	pImportButton = [[UIBarButtonItem alloc] initWithTitle:@"Import"
													 style:UIBarButtonItemStylePlain
													target:self
													action:@selector(onImportButton:)];
	self.navigationItem.rightBarButtonItem = pImportButton;
	
	return;
}

//******************************************************************************
// インターフェース自動回転確認
//******************************************************************************
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    return YES;
}

//******************************************************************************
// インターフェース自動回転確認（iOS6以降）
//******************************************************************************
- (BOOL)shouldAutorotate
{
	//回転を許可する
	return YES;
}

//******************************************************************************
// インターフェース自動回転確認：回転方向（iOS6以降）
//******************************************************************************
- (NSUInteger)supportedInterfaceOrientations
{
	//全方向に対応する
	return UIInterfaceOrientationMaskAll;
}

//******************************************************************************
// ビュー表示
//******************************************************************************
- (void)viewWillAppear:(BOOL)animated
{	
	return;
}

//******************************************************************************
// ビュー非表示
//******************************************************************************
- (void)viewWillDisappear:(BOOL)animated
{
	return;
}

//******************************************************************************
// Importボタン選択イベント
//******************************************************************************
- (void)onImportButton:(id)sender
{
	//パラメータインポート処理実行通知
	[self postNotificationWithName:m_pNotificationNameForImportParam];
	
	//1階層戻る
	[self.navigationController popViewControllerAnimated:YES];
	
	return;
}

//******************************************************************************
// 通知送信処理
//******************************************************************************
- (int)postNotificationWithName:(NSString*)pName
{
	int result = 0;
	NSNotification* pNotification = nil;
	NSNotificationCenter* pCenter = nil;
	
	//通知オブジェクトを作成
	pNotification = [NSNotification notificationWithName:pName
												  object:self
												userInfo:nil];
	//通知する
	pCenter = [NSNotificationCenter defaultCenter];
	
	//通知に対応する処理を演奏スレッドで処理させる場合
	//[pCenter postNotification:pNotification];
	
	//通知に対応する処理をメインスレッドに処理させる場合
	[pCenter performSelectorOnMainThread:@selector(postNotification:)
							  withObject:pNotification
						   waitUntilDone:NO];
	
	return result;
}

//******************************************************************************
// パラメータ文字列取得
//******************************************************************************
- (NSString*)getParamString
{
	return m_pTextView.text;
}

@end

