//******************************************************************************
//
// MIDITrail / MTSettingColorViewCtrl
//
// カラー設定ビュークラス
//
// Copyright (C) 2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "MTColorConf.h"
#import "MTSettingColorPaletteViewCtrl.h"


//******************************************************************************
// カラー設定ビュー制御クラス
//******************************************************************************
@interface MTSettingColorViewCtrl : UIViewController <UIDocumentPickerDelegate> {
	
	//テーブルビュー
	IBOutlet UITableView* m_pTableView;
	
	//カラー情報
	MTColorConf m_ColorConf;
	
	//カラーパレット設定ビュー
	MTSettingColorPaletteViewCtrl* m_pSettingColorPaletteViewCtrl;
}

//生成
- (id)init;

//破棄
- (void)dealloc;

//ビュー登録完了
- (void)viewDidLoad;

//インターフェース自動回転確認
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation;

//インターフェース自動回転確認（iOS6以降）
- (BOOL)shouldAutorotate;
- (NSUInteger)supportedInterfaceOrientations;

//ビュー表示
- (void)viewWillAppear:(BOOL)animated;

//ビュー非表示
- (void)viewWillDisappear:(BOOL)animated;

//セクション数
-(NSInteger)numberOfSectionsInTableView:(UITableView*)tableView;

//セクションヘッダ
- (NSString*)tableView:(UITableView*)tableView titleForHeaderInSection:(NSInteger)section;

//セクションごとの項目数
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section;

//項目表示内容
- (UITableViewCell*)tableView:(UITableView*)tableView cellForRowAtIndexPath:(NSIndexPath*)indexPath;

//テーブルセル選択イベント
- (void)tableView:(UITableView*)tableView didSelectRowAtIndexPath:(NSIndexPath*)indexPath;

//選択行ファイルパス取得
//- (NSString*)selectedFilePath;

//編集開始終了通知
- (void)setEditing:(BOOL)editing animated:(BOOL)animated;

// 行単位 編集可否判定
- (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath;

// 行単位 編集スタイル
- (UITableViewCellEditingStyle)tableView:(UITableView *)tableView editingStyleForRowAtIndexPath:(NSIndexPath *)indexPath;

// 行単位 編集時インデント
- (BOOL)tableView:(UITableView *)tableview shouldIndentWhileEditingRowAtIndexPath:(NSIndexPath *)indexPath;

//選択カラーパレット画像取得
- (UIImage*)getSelectedColorPaletteImage;

//選択カラーパレットテキスト取得
- (NSString*)getSelectedColorPaletteText;

@end

