//******************************************************************************
//
// MIDITrail / MTSettingDelayBetweenSongsViewCtrl
//
// 曲間待機時間設定ビュークラス
//
// Copyright (C) 2021 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import <UIKit/UIKit.h>
#import "YNBaseLib.h"


//******************************************************************************
// 曲間待機時間設定ビュー制御クラス パラメタ定義
//******************************************************************************
//曲間待機時間（秒） 最小値/最大値
#define MT_DELAY_BETWEEN_SONGS_MIN		(0)
#define MT_DELAY_BETWEEN_SONGS_MAX		(10)
#define MT_DELAY_BETWEEN_SONGS_STEP		(1)


//******************************************************************************
// 曲間待機時間設定ビュー制御クラス
//******************************************************************************
@interface MTSettingDelayBetweenSongsViewCtrl : UIViewController {
	
	//テーブルビュー
	IBOutlet UITableView* m_pTableView;
	
	//待機時間リスト
	NSMutableArray* m_pDelaySecondsArray;
	
	//待機時間
	int m_DelaySeconds;
	
	//ユーザ設定
	YNUserConf* m_pUserConf;
}

//生成
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil;

//ビュー登録完了
- (void)viewDidLoad;

//インターフェース自動回転確認
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation;

//インターフェース自動回転確認（iOS6以降）
- (BOOL)shouldAutorotate;
- (NSUInteger)supportedInterfaceOrientations;

//ビュー表示
- (void)viewWillAppear:(BOOL)animated;

//ビュー非表示
- (void)viewWillDisappear:(BOOL)animated;

//セクション数
-(NSInteger)numberOfSectionsInTableView:(UITableView*)tableView;

//セクションヘッダ
- (NSString*)tableView:(UITableView*)tableView titleForHeaderInSection:(NSInteger)section;

//セクションごとの項目数
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section;

//項目表示内容
- (UITableViewCell*)tableView:(UITableView*)tableView cellForRowAtIndexPath:(NSIndexPath*)indexPath;

//テーブルセル選択イベント
- (void)tableView:(UITableView*)tableView didSelectRowAtIndexPath:(NSIndexPath*)indexPath;

//選択待機時間（秒）取得
- (int)selectedDelaySeconds;

@end

