//******************************************************************************
//
// MIDITrail / MTTextViewCtrl
//
// テキストビューア制御クラス
//
// Copyright (C) 2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************


//******************************************************************************
// ヘルプ画面制御クラス
//******************************************************************************
@interface MTTextViewCtrl : UIViewController {
	
	//テキストビュー
	IBOutlet UITextView* m_pTextView;
	
	//ファイルパス
	NSString* m_pFilePath;
	
	//エンコーディングID
	NSStringEncoding m_EncodingId;
	
}

//生成
- (id)init;

//破棄
- (void)dealloc;

//ファイルパス設定
- (void)setFilePath:(NSString*)pFilePath;

//エンコーディグID設定
- (void)setEncodingId:(NSStringEncoding)encodingId;

//ビュー登録完了
- (void)viewDidLoad;

//インターフェース自動回転確認
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation;

//インターフェース自動回転確認（iOS6以降）
- (BOOL)shouldAutorotate;
- (NSUInteger)supportedInterfaceOrientations;

//ビュー表示
- (void)viewWillAppear:(BOOL)animated;

//ビュー非表示
- (void)viewWillDisappear:(BOOL)animated;

@end

