//******************************************************************************
//
// MIDITrail / MTTextViewCtrl
//
// テキストビューア画面制御クラス
//
// Copyright (C) 2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "YNBaseLib.h"
#import "MTTextViewCtrl.h"


//******************************************************************************
// プライベートメソッド定義
//******************************************************************************
@interface MTTextViewCtrl ()

@end


@implementation MTTextViewCtrl

//******************************************************************************
// 生成
//******************************************************************************
- (id)init
{
	int result = 0;
	NSString* pNibName = nil;
	
	//ビュー生成
	if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPhone) {
		//iPhone / iPod touch
		pNibName = @"MTTextView_iPhone";
	}
	else {
		//iPad
		pNibName = @"MTTextView_iPad";
	}
	
	self = [super initWithNibName:pNibName bundle:nil];
	if (self == nil) {
		result = YN_SET_ERR(@"Program error.", 0, 0);
		goto EXIT;
	}
	
	m_pFilePath = nil;
	m_EncodingId = NSASCIIStringEncoding;
	
EXIT:;
	if (result != 0) YN_SHOW_ERR();
    return self;
}

//******************************************************************************
// 破棄
//******************************************************************************
- (void)dealloc
{
	[m_pFilePath release];
	[super dealloc];
}

//******************************************************************************
// ファイルパス設定
//******************************************************************************
- (void)setFilePath:(NSString*)pFilePath
{
	[m_pFilePath release];
	m_pFilePath = pFilePath;
	[m_pFilePath retain];
	
	return;
}

//******************************************************************************
// エンコーディグID設定
//******************************************************************************
- (void)setEncodingId:(NSStringEncoding)encodingId
{
	m_EncodingId = encodingId;
}

//******************************************************************************
// ビュー登録完了
//******************************************************************************
- (void)viewDidLoad
{
    [super viewDidLoad];
	
	return;
}

//******************************************************************************
// インターフェース自動回転確認
//******************************************************************************
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
	return YES;
}

//******************************************************************************
// インターフェース自動回転確認（iOS6以降）
//******************************************************************************
- (BOOL)shouldAutorotate
{
	//回転を許可する
	return YES;
}

//******************************************************************************
// インターフェース自動回転確認：回転方向（iOS6以降）
//******************************************************************************
- (NSUInteger)supportedInterfaceOrientations
{
	//全方向に対応する
	return UIInterfaceOrientationMaskAll;
}

//******************************************************************************
// ビュー表示
//******************************************************************************
- (void)viewWillAppear:(BOOL)animated
{
	int result = 0;
	BOOL isExist = NO;
	NSString* pText = nil;
	NSError* pError = nil;
	
	//ファイルパス未設定の場合は何もしない
	if (m_pFilePath == nil) goto EXIT;
	
	//タイトル：ファイル名
	self.title = [m_pFilePath lastPathComponent];
	
	//ファイルの存在確認
	isExist = [[NSFileManager defaultManager] fileExistsAtPath:m_pFilePath];
	if (!isExist) {
		result = YN_SET_ERR(@"File not found.", 0, 0);
		goto EXIT;
	}
	
	//文字コードを指定してファイルを読み込む
	pText = [NSString stringWithContentsOfFile:m_pFilePath encoding:m_EncodingId error:&pError];
	if (pText == nil) {
		//エンコードIDを指定して読み込みができなかった場合は、UTF-8で再度読み込みを試す
		pText = [NSString stringWithContentsOfFile:m_pFilePath encoding:NSUTF8StringEncoding error:&pError];
		if (pText == nil) {
			//それでも読み込めなかった場合は何も表示しない
			pText = @"";
		}
	}
	
	//テキスト設定
	m_pTextView.text = pText;
	
EXIT:;
	if (result != 0) YN_SHOW_ERR();
	return;
}

//******************************************************************************
// ビュー非表示
//******************************************************************************
- (void)viewWillDisappear:(BOOL)animated
{
	return;
}

@end

