//******************************************************************************
//
// MIDITrail / MTTimeIndicatorRing
//
// タイムインジケータリング描画クラス
//
// Copyright (C) 2019-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// 「今再生しているところ」を指し示す再生面を描画する。

#import "OGLUtil.h"
#import "SMIDILib.h"
#import "MTNoteDesignRing.h"


//******************************************************************************
// タイムインジケータリング描画クラス
//******************************************************************************
class MTTimeIndicatorRing
{
public:

	//コンストラクタ／デストラクタ
	MTTimeIndicatorRing(void);
	virtual ~MTTimeIndicatorRing(void);

	//生成
	int Create(OGLDevice* pOGLDevice, NSString* pSceneName, SMSeqData* pSeqData);

	//更新
	int Transform(OGLDevice* pOGLDevice, OGLVECTOR3 camVector, float rollAngle);

	//描画
	int Draw(OGLDevice* pOGLDevice);

	//解放
	void Release();

	//演奏チックタイム登録
	void SetCurTickTime(unsigned int curTickTime);

	//リセット
	void Reset();

	//現在位置取得
	float GetPos();

	//移動ベクトル取得
	OGLVECTOR3 GetMoveVector();
	
	//表示設定
	void SetEnable(bool isEnable);
	
private:

	OGLPrimitive m_PrimitiveLine;
	float m_CurPos;
	MTNoteDesignRing m_NoteDesign;
	unsigned int m_CurTickTime;
	bool m_isEnable;

	//頂点バッファ構造体
	typedef OGLVERTEX_V3N3C MTTIMEINDICATOR_VERTEX;
	//struct MTTIMEINDICATOR_VERTEX {
	//	OGLVECTOR3 p;	//頂点座標
	//	OGLVECTOR3 n;	//法線
	//	DWORD		c;	//ディフューズ色
	//};

	//頂点バッファFVFフォーマット
	unsigned int _GetFVFFormat(){ return OGLVERTEX_TYPE_V3N3C; }

	int _CreatePrimitiveLine(OGLDevice* pOGLDevice);
	int _CreateVertexOfIndicatorLine(MTTIMEINDICATOR_VERTEX* pVertex, unsigned int* pIndex);

};


