//******************************************************************************
//
// OGL Utility / OGLRenderer
//
// レンダラクラス
//
// Copyright (C) 2010-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "OGLTypes.h"
#import "OGLDevice.h"
#import "OGLScene.h"


//******************************************************************************
// 構造体定義
//******************************************************************************
typedef struct {
	BOOL isEnableAntialiasing;
	int sampleMode;
	int sampleNum;
} OGLRedererParam;

//******************************************************************************
// レンダラクラス
//******************************************************************************
class OGLRenderer
{
public:
	
	//コンストラクタ／デストラクタ
	OGLRenderer();
	virtual ~OGLRenderer();
	
	//初期化
	int Initialize(MTKView* pView, OGLRedererParam rendererParam);
	
	//デバイス取得
	OGLDevice* GetDevice();
	
	//シーンクリア
	int InitScene();
	
	//シーン描画
	int RenderScene(MTKView* pView, OGLScene* pScene, bool isVRViewDualLens, CGFloat ipdPoints);
	
	//終了処理
	void Terminate();
	
private:
	
	//デバイス
	OGLDevice* m_pOGLDevice;
	
	//描画セマフォ
	dispatch_semaphore_t m_DisplaySemaphore;
	
	//コマンドキュー
	id <MTLCommandQueue> m_CommandQueue;
	
	//シーン描画
	int _DrawScene(MTKView* pView, OGLScene* pScene, bool isVRViewDualLens, CGFloat ipdPoints);

};


