//******************************************************************************
//
// OGL Utility / OGLRendererInfo
//
// レンダラ情報クラス
//
// Copyright (C) 2010-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import <MetalKit/MetalKit.h>
#import "YNBaseLib.h"
#import "OGLRendererInfo.h"


//*****************************************************************************
// コンストラクタ
//******************************************************************************
OGLRendererInfo::OGLRendererInfo(void)
{
}

//*****************************************************************************
// デストラクタ
//******************************************************************************
OGLRendererInfo::~OGLRendererInfo(void)
{
	m_AntialiasInfoList.clear();
}

//*****************************************************************************
// 初期化
//******************************************************************************
int OGLRendererInfo::Initialize()
{
	int result = 0;
	
	//ハードウェアのアンチエイリアシングサポート状況を確認する
	result = _CheckAntialias();
	if (result != 0) goto EXIT;
	
EXIT:;
	return result;
}

//*****************************************************************************
// アンチエイリアシングサポートチェック
//******************************************************************************
int OGLRendererInfo::_CheckAntialias()
{
	int result = 0;
	OGLint sampleCount = 0;
	OGLAntialiasInfo info;
	id <MTLDevice> mtlDevice = nil;
	
	m_AntialiasInfoList.clear();
	
	//デバイス生成
	mtlDevice = MTLCreateSystemDefaultDevice();
	if (mtlDevice == nil) {
		result = YN_SET_ERR(@"Metal API error.", 0, 0);
		goto EXIT;
	}
	
	//サンプル数のサポート状況を確認
	for (sampleCount = 2; sampleCount < 16; sampleCount++) {
		//サンプル数がサポートされていたらアンチエイリアス情報を登録
		if ([mtlDevice supportsTextureSampleCount:sampleCount]) {
			NSLog(@"sampleCount: %d", sampleCount);
			info.sampleMode = OGLMultisampleBit;
			info.sampleNum = sampleCount;
			m_AntialiasInfoList.push_back(info);
		}
	}
	
EXIT:;
	return result;
}

//*****************************************************************************
// アンチエイリアスサポート情報数取得
//*****************************************************************************
unsigned int OGLRendererInfo::GetAntialiasInfoNum()
{
	return (unsigned int)m_AntialiasInfoList.size();
}

//*****************************************************************************
// アンチエイリアスサポート情報取得
//*****************************************************************************
int OGLRendererInfo::GetAntialiasInfo(
		NSInteger index,
		OGLAntialiasInfo* pAntialiasInfo
	)
{
	int result = 0;
	OGLAntialiasListItr itr;
	
	if (index >= m_AntialiasInfoList.size()) {
		result = YN_SET_ERR(@"Program error.", index, 0);
		goto EXIT;
	}
	
	itr = m_AntialiasInfoList.begin();
	advance(itr, index);
	*pAntialiasInfo = *itr;
	
EXIT:;
	return result;
}


