//******************************************************************************
//
// OGL Utility / OGLTexture
//
// テクスチャクラス
//
// Copyright (C) 2010-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "OGLTypes.h"
#import "OGLDevice.h"


//******************************************************************************
// パラメータ定義
//******************************************************************************
//テクスチャサイズ最大値
#define OGL_MAX_TEXTURE_SIZE  (4096)

//******************************************************************************
// テクスチャクラス
//******************************************************************************
class OGLTexture
{
public:
	
	//コンストラクタ／デストラクタ
	OGLTexture(void);
	virtual ~OGLTexture(void);
	
	//任意画像サイズ有効化：初期値 false
	//void EnableRectanbleExt(bool isEnable);
	
	//画像ファイル読み込み
	int LoadImageFile(OGLDevice* pDevice, NSString* pImageFilePath);
	
	//ビットマップ読み込み
	int LoadBitmap(OGLDevice* pDevice, UIImage* pBitmapImage);
	
	//破棄
	void Release();
	
	//テクスチャサイズ取得
	OGLsizei GetWidth();
	OGLsizei GetHeight();
	
	//テクスチャ描画開始処理
	void BindTexture(OGLDevice* pDevice, NSUInteger textureIndex);
	void UnbindTexture(OGLDevice* pDevice);
	
protected:
	
	id <MTLTexture> m_Texture;
	NSUInteger m_TextureIndex;
	bool m_isLoaded;
	OGLsizei m_Width;
	OGLsizei m_Height;
	
private:
	
	//代入とコピーコンストラクタの禁止
	void operator=(const OGLTexture&);
	OGLTexture(const OGLTexture&);
	
	UIImage* m_pBitmapImage;
	CFDataRef m_CFDataRef;
	
};


