#!/bin/sh
#
# addapp.sh - Add application bundles from start menu or specified exe files
#
# Copyright (C) 2008 MikuInstaller Project. All rights reserved.
# http://mikuinstaller.sourceforge.jp/
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
# THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS
# BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
# WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
# OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
# IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

MIKUVERSION=@VERSION@

set -e
PATH=/usr/bin:/bin:/usr/sbin

if [ -z "$MIKUBUNDLE" ]; then
  dir=`dirname "$0"`
  MIKUBUNDLE=`cd "$dir/../../.." && pwd`
fi
MIKURESOURCE="$MIKUBUNDLE/Contents/Resources"

if [ -z "$WINEPREFIX" ] || [ ! -d "$WINEPREFIX" ]; then
  echo "$0: WINEPREFIX does not exist." 1>&2
  exit 1
fi

dstdir=.
if [ "x$1" = "--" ]; then
  shift
elif expr "x$1" : 'x-d' > /dev/null; then
  dstdir=`expr "x$1" : 'x-d\(.*\)'`
  shift
fi

tmp=`mktemp -d -t tmp` || exit $?
trap "rm -rf $tmp" EXIT

(
  cd "$tmp"
  set -- wine "$MIKURESOURCE/lib/startmenu.exe.so" "$@"
  . "$MIKURESOURCE/script/startwine.sh"
) || exit $?

for i in "$tmp/_Entry"*; do
  [ -f "$i" ] || break
  (
    set -- "-d$dstdir" "$i"
    . "$MIKURESOURCE/script/createapp.sh"
  ) || exit $?
done
