#!/bin/sh
#
# start.sh - Toplevel application starter
#
# Copyright (C) 2008 MikuInstaller Project. All rights reserved.
# http://mikuinstaller.sourceforge.jp/
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
# THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS
# BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
# WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
# OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
# IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

MIKUVERSION=@VERSION@

set -e
PATH=/usr/bin:/bin:/usr/sbin

if [ -z "$MIKUBUNDLE" ]; then
  dir=`dirname "$0"`
  MIKUBUNDLE=`cd "$dir/../.." && pwd`
fi
MIKURESOURCE="$MIKUBUNDLE/Contents/Resources"

if [ -z "$LANG" ]; then
  LANG=ja_JP.UTF-8
  export LANG
fi

if [ "x$1" = "x--miku=debug" ]; then
  shift
  set -x
fi

# MikuInstaller extensions
mikucmd=
mikucmd=`expr "x$1" : "x--miku=\(.*\)"` && shift
case "$mikucmd" in
  version)            # print version of MikuInstaller
    echo "$MIKUVERSION"
    exit
    ;;
  compat)             # check MikuInstaller compatibility
    # FIXME: stub
    test "x$1" = "x$MIKUVERSION"
    exit $?
    ;;
  addapp)             # add application bundles from start menu or exe file
    . "$MIKURESOURCE/script/addapp.sh"
    exit
    ;;
  prefixcreate)       # create WINEPREFIX
    . "$MIKURESOURCE/script/wineprefixcreate.sh"
    exit
    ;;
  winecmd)            # invoke a wine/bin command
    # pass through to startwine.sh
    ;;
  shellexec)          # open a file by ShellExecEx.
    set -- wine "$MIKURESOURCE/lib/shellexec.exe.so" "$@"
    ;;
  '')                 # no extension specified; wine compatible mode
    set -- wine "$@"
    ;;
  *)
    echo "$0: unknown command \`$mikucmd'" 1>&2
    exit 1
    ;;
esac

. "$MIKURESOURCE/script/startx11.sh"
. "$MIKURESOURCE/script/wineprefixcreate.sh"

osascript <<END || :
with timeout 3 seconds
  tell application "X11" to activate
end timeout
END

. "$MIKURESOURCE/script/startwine.sh"
