#!/bin/sh
#
# startwine.sh - start a wine command
#
# Wine requires that
# - X11 is already launched and $DISPLAY is appropriately set.
# - LD_LIBRARY_PATH includes a path to X11 libraries.
#
# Copyright (C) 2008 MikuInstaller Project. All rights reserved.
# http://mikuinstaller.sourceforge.jp/
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
# THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS
# BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
# WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
# OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
# IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

MIKUVERSION=@VERSION@

set -e
PATH=/usr/bin:/bin:/usr/sbin

if [ -z "$MIKUBUNDLE" ]; then
  dir=`dirname "$0"`
  MIKUBUNDLE=`cd "$dir/../../.." && pwd`
fi
MIKURESOURCE="$MIKUBUNDLE/Contents/Resources"
MIKUFRAMEWORK="$MIKUBUNDLE/Contents/SharedFrameworks"
MIKUSUPPORT="$MIKUBUNDLE/Contents/SharedSupport"

if [ -z "$DISPLAY" ]; then
  . "$MIKURESOURCE/script/startx11.sh"
fi

# libfreetype.6.dylib is one of essential library for Wine.
if [ -f "/usr/X11/lib/libfreetype.6.dylib" ]; then
  X11DIR=/usr/X11
elif [ -f "/usr/X11R6/lib/libfreetype.6.dylib" ]; then
  X11DIR=/usr/X11R6
else
  echo "WARNING: libfreetype.6.dylib is not found in the standard place." 1>&2
  if [ -d "/usr/X11" ]; then
    X11DIR=/usr/X11
  else
    X11DIR=/usr/X11R6
  fi
fi

if [ -n "$LD_LIBRARY_PATH" ]; then
  LD_LIBRARY_PATH="$LD_LIBRARY_PATH:"
fi
LD_LIBRARY_PATH="$LD_LIBRARY_PATH""$MIKURESOURCE/lib:$MIKUFRAMEWORK/lib:$X11DIR/lib"
export LD_LIBRARY_PATH

#
# WORKAROUND: Wine doesn't work with Apple's X11 on Tiger due to
# something wrong of OpenGL support of Apple's X11.
# To avoid this problem, we force to disable OpenGL support of wine
# if X11 is XFree86.
#
if $X11DIR/bin/xdpyinfo 2>&1 | grep XFree86 > /dev/null 2>&1; then
  WINE_OPENGL_HACK=0
  export WINE_OPENGL_HACK
fi

PATH="$MIKUSUPPORT/bin:$PATH"

prog="$1"
shift
exec "$prog" "$@"
