/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.cinematic;

import com.jme3.animation.LoopMode;
import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.cinematic.KeyFrame;
import com.jme3.cinematic.PlayState;
import com.jme3.cinematic.TimeLine;
import com.jme3.cinematic.events.AbstractCinematicEvent;
import com.jme3.cinematic.events.CinematicEvent;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.niftygui.NiftyJmeDisplay;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.scene.CameraNode;
import com.jme3.scene.Node;
import com.jme3.scene.control.CameraControl;
import de.lessvoid.nifty.Nifty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cinematic
extends AbstractCinematicEvent
implements AppState {
    private static final Logger logger = Logger.getLogger(Application.class.getName());
    private String niftyXmlPath = null;
    private Node scene;
    protected TimeLine timeLine = new TimeLine();
    private int lastFetchedKeyFrame = -1;
    private List<CinematicEvent> cinematicEvents = new ArrayList<CinematicEvent>();
    private Map<String, CameraNode> cameras = new HashMap<String, CameraNode>();
    private CameraNode currentCam;
    private boolean initialized = false;
    private Nifty nifty = null;
    private Map<String, Map<String, Object>> eventsData;

    public Cinematic() {
    }

    public Cinematic(Node scene) {
        this.scene = scene;
    }

    public Cinematic(Node scene, float initialDuration) {
        super(initialDuration);
        this.scene = scene;
    }

    public Cinematic(Node scene, LoopMode loopMode) {
        super(loopMode);
        this.scene = scene;
    }

    public Cinematic(Node scene, float initialDuration, LoopMode loopMode) {
        super(initialDuration, loopMode);
        this.scene = scene;
    }

    @Override
    public void onPlay() {
        if (this.isInitialized()) {
            this.enableCurrentCam(true);
            if (this.playState == PlayState.Paused) {
                for (int i = 0; i < this.cinematicEvents.size(); ++i) {
                    CinematicEvent ce = this.cinematicEvents.get(i);
                    if (ce.getPlayState() != PlayState.Paused) continue;
                    ce.play();
                }
            }
        }
    }

    @Override
    public void onStop() {
        this.time = 0.0f;
        this.lastFetchedKeyFrame = -1;
        for (int i = 0; i < this.cinematicEvents.size(); ++i) {
            CinematicEvent ce = this.cinematicEvents.get(i);
            ce.stop();
        }
        this.enableCurrentCam(false);
    }

    @Override
    public void onPause() {
        for (int i = 0; i < this.cinematicEvents.size(); ++i) {
            CinematicEvent ce = this.cinematicEvents.get(i);
            if (ce.getPlayState() != PlayState.Playing) continue;
            ce.pause();
        }
        this.enableCurrentCam(false);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.writeSavableArrayList((ArrayList)this.cinematicEvents, "cinematicEvents", null);
        oc.writeStringSavableMap(this.cameras, "cameras", null);
        oc.write(this.timeLine, "timeLine", null);
        oc.write(this.niftyXmlPath, "niftyXmlPath", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.cinematicEvents = ic.readSavableArrayList("cinematicEvents", null);
        this.cameras = ic.readStringSavableMap("cameras", null);
        this.timeLine = (TimeLine)ic.readSavable("timeLine", null);
        this.niftyXmlPath = ic.readString("niftyXmlPath", null);
    }

    public void bindUi(String xmlPath) {
        this.niftyXmlPath = xmlPath;
    }

    @Override
    public void setSpeed(float speed) {
        super.setSpeed(speed);
        this.duration = this.initialDuration / speed;
        for (int i = 0; i < this.cinematicEvents.size(); ++i) {
            CinematicEvent ce = this.cinematicEvents.get(i);
            ce.setSpeed(speed);
        }
    }

    @Override
    public void initialize(AppStateManager stateManager, Application app) {
        if (this.niftyXmlPath != null) {
            NiftyJmeDisplay niftyDisplay = new NiftyJmeDisplay(app.getAssetManager(), app.getInputManager(), app.getAudioRenderer(), app.getGuiViewPort());
            this.nifty = niftyDisplay.getNifty();
            this.nifty.fromXmlWithoutStartScreen(this.niftyXmlPath);
            app.getGuiViewPort().addProcessor(niftyDisplay);
        }
        for (CinematicEvent cinematicEvent : this.cinematicEvents) {
            cinematicEvent.initEvent(app, this);
        }
        this.initialized = true;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.play();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.playState == PlayState.Playing;
    }

    @Override
    public void stateAttached(AppStateManager stateManager) {
    }

    @Override
    public void stateDetached(AppStateManager stateManager) {
        this.stop();
    }

    @Override
    public void update(float tpf) {
        if (this.isInitialized()) {
            this.internalUpdate(tpf);
        }
    }

    @Override
    public void onUpdate(float tpf) {
        for (int i = 0; i < this.cinematicEvents.size(); ++i) {
            CinematicEvent ce = this.cinematicEvents.get(i);
            ce.internalUpdate(tpf);
        }
        int keyFrameIndex = this.timeLine.getKeyFrameIndexFromTime(this.time);
        for (int i = this.lastFetchedKeyFrame + 1; i <= keyFrameIndex; ++i) {
            KeyFrame keyFrame = (KeyFrame)this.timeLine.get(i);
            if (keyFrame == null) continue;
            keyFrame.trigger();
        }
        this.lastFetchedKeyFrame = keyFrameIndex;
    }

    public KeyFrame addCinematicEvent(float timeStamp, CinematicEvent cinematicEvent) {
        KeyFrame keyFrame = this.timeLine.getKeyFrameAtTime(timeStamp);
        if (keyFrame == null) {
            keyFrame = new KeyFrame();
            this.timeLine.addKeyFrameAtTime(timeStamp, keyFrame);
        }
        keyFrame.cinematicEvents.add(cinematicEvent);
        this.cinematicEvents.add(cinematicEvent);
        return keyFrame;
    }

    @Override
    public void render(RenderManager rm) {
    }

    @Override
    public void postRender() {
    }

    @Override
    public void cleanup() {
    }

    public void fitDuration() {
        KeyFrame kf = this.timeLine.getKeyFrameAtTime(this.timeLine.getLastKeyFrameIndex());
        float d = 0.0f;
        for (int i = 0; i < kf.getCinematicEvents().size(); ++i) {
            CinematicEvent ce = kf.getCinematicEvents().get(i);
            if (!(d < ce.getDuration() * ce.getSpeed())) continue;
            d = ce.getDuration() * ce.getSpeed();
        }
        this.initialDuration = d;
    }

    public CameraNode bindCamera(String cameraName, Camera cam) {
        CameraNode node = new CameraNode(cameraName, cam);
        node.setControlDir(CameraControl.ControlDirection.SpatialToCamera);
        node.getControl(0).setEnabled(false);
        this.cameras.put(cameraName, node);
        this.scene.attachChild(node);
        return node;
    }

    public CameraNode getCamera(String cameraName) {
        return this.cameras.get(cameraName);
    }

    private void enableCurrentCam(boolean enabled) {
        if (this.currentCam != null) {
            this.currentCam.getControl(0).setEnabled(enabled);
        }
    }

    public void setActiveCamera(String cameraName) {
        this.enableCurrentCam(false);
        this.currentCam = this.cameras.get(cameraName);
        if (this.currentCam == null) {
            logger.log(Level.WARNING, "{0} is not a camera bond to the cinematic, cannot activate", cameraName);
        }
        this.enableCurrentCam(true);
    }

    public void activateCamera(float time, final String cameraName) {
        this.addCinematicEvent(time, new AbstractCinematicEvent(){

            public void onPlay() {
                Cinematic.this.setActiveCamera(cameraName);
                this.stop();
            }

            public void onUpdate(float tpf) {
            }

            public void onStop() {
            }

            public void onPause() {
            }
        });
    }

    public void setScene(Node scene) {
        this.scene = scene;
    }

    public Nifty getNifty() {
        return this.nifty;
    }

    private Map<String, Map<String, Object>> getEventsData() {
        if (this.eventsData == null) {
            this.eventsData = new HashMap<String, Map<String, Object>>();
        }
        return this.eventsData;
    }

    public void putEventData(String type, String name, Object object) {
        Map<String, Map<String, Object>> data = this.getEventsData();
        Map<String, Object> row = data.get(type);
        if (row == null) {
            row = new HashMap<String, Object>();
        }
        row.put(name, object);
    }

    public Object getEventData(String type, String name) {
        Map<String, Object> row;
        if (this.eventsData != null && (row = this.eventsData.get(type)) != null) {
            return row.get(name);
        }
        return null;
    }

    public Savable removeEventData(String type, String name) {
        Map<String, Object> row;
        if (this.eventsData != null && (row = this.eventsData.get(type)) != null) {
            row.remove(name);
        }
        return null;
    }

    public Node getScene() {
        return this.scene;
    }
}

