/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.awt;

import com.jme3.input.MouseInput;
import com.jme3.input.RawInputListener;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class AwtMouseInput
implements MouseInput,
MouseListener,
MouseWheelListener,
MouseMotionListener {
    private static final Logger logger = Logger.getLogger(AwtMouseInput.class.getName());
    private boolean inited = false;
    private boolean visible = true;
    private RawInputListener listener;
    private Component component;
    private ArrayList<MouseButtonEvent> eventQueue = new ArrayList();
    private int lastEventX;
    private int lastEventY;
    private int lastEventWheel;
    private Cursor transparentCursor;
    private Robot robot;
    private int wheelPos;
    private Point location;
    private Point centerLocation;
    private Point centerLocationOnScreen;
    private Point lastKnownLocation;
    private boolean isRecentering;
    private int eventsSinceRecenter;

    public AwtMouseInput(Component comp) {
        this.component = comp;
        this.location = new Point();
        this.centerLocation = new Point();
        this.centerLocationOnScreen = new Point();
        this.lastKnownLocation = new Point();
        try {
            this.robot = new Robot();
        }
        catch (AWTException e) {
            logger.log(Level.SEVERE, "Could not create a robot, so the mouse cannot be grabbed! ", e);
        }
    }

    public void initialize() {
        this.inited = true;
        this.component.addMouseListener(this);
        this.component.addMouseMotionListener(this);
        this.component.addMouseWheelListener(this);
        logger.info("Mouse input initialized.");
    }

    public void destroy() {
        this.inited = false;
        this.robot = null;
        this.component.removeMouseListener(this);
        this.component.removeMouseMotionListener(this);
        this.component.removeMouseWheelListener(this);
        logger.info("Mouse input destroyed.");
    }

    public boolean isInitialized() {
        return this.inited;
    }

    public void setInputListener(RawInputListener listener) {
        this.listener = listener;
    }

    public long getInputTimeNanos() {
        return System.nanoTime();
    }

    public void setCursorVisible(boolean visible) {
        if (this.visible != visible) {
            this.component.setCursor(visible ? null : this.getTransparentCursor());
            this.visible = visible;
            if (!visible) {
                this.recenterMouse(this.component);
            }
        }
    }

    public void update() {
        int newX = this.location.x;
        int newY = this.location.y;
        int newWheel = this.wheelPos;
        MouseMotionEvent evt = new MouseMotionEvent(newX, newY, newX - this.lastEventX, this.lastEventY - newY, this.wheelPos, this.lastEventWheel - this.wheelPos);
        this.listener.onMouseMotionEvent(evt);
        int size = this.eventQueue.size();
        for (int i = 0; i < size; ++i) {
            this.listener.onMouseButtonEvent(this.eventQueue.get(i));
        }
        this.eventQueue.clear();
        this.lastEventX = newX;
        this.lastEventY = newY;
        this.lastEventWheel = newWheel;
    }

    private final Cursor getTransparentCursor() {
        if (this.transparentCursor == null) {
            BufferedImage cursorImage = new BufferedImage(1, 1, 2);
            cursorImage.setRGB(0, 0, 0);
            this.transparentCursor = Toolkit.getDefaultToolkit().createCustomCursor(cursorImage, new Point(0, 0), "empty cursor");
        }
        return this.transparentCursor;
    }

    public int getButtonCount() {
        return 3;
    }

    public void mouseClicked(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent arg0) {
        MouseButtonEvent evt = new MouseButtonEvent(this.getJMEButtonIndex(arg0), true, arg0.getX(), arg0.getY());
        evt.setTime(arg0.getWhen());
        this.eventQueue.add(evt);
    }

    public void mouseReleased(MouseEvent arg0) {
        MouseButtonEvent evt = new MouseButtonEvent(this.getJMEButtonIndex(arg0), false, arg0.getX(), arg0.getY());
        evt.setTime(arg0.getWhen());
        this.eventQueue.add(evt);
    }

    public void mouseEntered(MouseEvent arg0) {
        if (!this.visible) {
            this.recenterMouse(arg0.getComponent());
        }
    }

    public void mouseExited(MouseEvent arg0) {
        if (!this.visible) {
            this.recenterMouse(arg0.getComponent());
        }
    }

    public void mouseWheelMoved(MouseWheelEvent arg0) {
        int dwheel = arg0.getUnitsToScroll();
        this.wheelPos -= dwheel;
    }

    public void mouseDragged(MouseEvent arg0) {
        this.mouseMoved(arg0);
    }

    public void mouseMoved(MouseEvent arg0) {
        if (this.isRecentering) {
            if (this.centerLocation.x == arg0.getX() && this.centerLocation.y == arg0.getY() || this.eventsSinceRecenter++ == 5) {
                this.lastKnownLocation.x = arg0.getX();
                this.lastKnownLocation.y = arg0.getY();
                this.isRecentering = false;
            }
        } else {
            int dx = arg0.getX() - this.lastKnownLocation.x;
            int dy = arg0.getY() - this.lastKnownLocation.y;
            this.location.x += dx;
            this.location.y += dy;
            if (!this.visible) {
                this.recenterMouse(arg0.getComponent());
            }
            this.lastKnownLocation.x = arg0.getX();
            this.lastKnownLocation.y = arg0.getY();
        }
    }

    private void recenterMouse(Component component) {
        if (this.robot != null) {
            this.eventsSinceRecenter = 0;
            this.isRecentering = true;
            this.centerLocation.setLocation(component.getWidth() / 2, component.getHeight() / 2);
            this.centerLocationOnScreen.setLocation(this.centerLocation);
            SwingUtilities.convertPointToScreen(this.centerLocationOnScreen, component);
            this.robot.mouseMove(this.centerLocationOnScreen.x, this.centerLocationOnScreen.y);
        }
    }

    private int getJMEButtonIndex(MouseEvent arg0) {
        int index;
        switch (arg0.getButton()) {
            default: {
                index = 0;
                break;
            }
            case 2: {
                index = 2;
                break;
            }
            case 3: {
                index = 1;
            }
        }
        return index;
    }
}

