/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoadException;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.AssetManager;
import com.jme3.asset.MaterialKey;
import com.jme3.asset.TextureKey;
import com.jme3.material.FixedFuncBinding;
import com.jme3.material.MatParam;
import com.jme3.material.Material;
import com.jme3.material.MaterialDef;
import com.jme3.material.RenderState;
import com.jme3.material.TechniqueDef;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.shader.Shader;
import com.jme3.shader.VarType;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.util.BufferUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.Scanner;

public class J3MLoader
implements AssetLoader {
    private AssetManager owner;
    private Scanner scan;
    private AssetKey key;
    private MaterialDef materialDef;
    private Material material;
    private TechniqueDef technique;
    private RenderState renderState;
    private String shaderLang;
    private String vertName;
    private String fragName;

    private void throwIfNequal(String expected, String got) throws IOException {
        if (expected == null) {
            throw new IOException("Expected a statement, got '" + got + "'!");
        }
        if (!expected.equals(got)) {
            throw new IOException("Expected '" + expected + "', got '" + got + "'!");
        }
    }

    private void nextStatement() {
        while (!this.scan.hasNext("\\}")) {
            if (this.scan.hasNext("[\n;]")) {
                this.scan.next();
                continue;
            }
            if (!this.scan.hasNext("//")) break;
            this.scan.useDelimiter("\n");
            this.scan.next();
            this.scan.useDelimiter("\\p{javaWhitespace}+");
        }
    }

    private String readString(String end) {
        this.scan.useDelimiter(end);
        String str = this.scan.next();
        this.scan.useDelimiter("\\p{javaWhitespace}+");
        return str.trim();
    }

    private Image createColorTexture(ColorRGBA color) {
        if (color.getAlpha() == 1.0f) {
            ByteBuffer data = BufferUtils.createByteBuffer(3);
            byte[] bytes = color.asBytesRGBA();
            data.put(bytes[0]).put(bytes[1]).put(bytes[2]);
            data.flip();
            return new Image(Image.Format.RGB8, 1, 1, data);
        }
        ByteBuffer data = BufferUtils.createByteBuffer(4);
        data.putInt(color.asIntRGBA());
        data.flip();
        return new Image(Image.Format.RGBA8, 1, 1, data);
    }

    private void readShaderStatement(Shader.ShaderType type) throws IOException {
        String lang = this.readString(":");
        String word = this.scan.next();
        this.throwIfNequal(":", word);
        word = this.readString("[\n;(\\})]");
        if (type == Shader.ShaderType.Vertex) {
            this.vertName = word;
        } else if (type == Shader.ShaderType.Fragment) {
            this.fragName = word;
        }
        this.shaderLang = lang;
    }

    private void readLightMode() {
        String mode = this.readString("[\n;(\\})]");
        TechniqueDef.LightMode lm = TechniqueDef.LightMode.valueOf(mode);
        this.technique.setLightMode(lm);
    }

    private void readShadowMode() {
        String mode = this.readString("[\n;(\\})]");
        TechniqueDef.ShadowMode sm = TechniqueDef.ShadowMode.valueOf(mode);
        this.technique.setShadowMode(sm);
    }

    private void readParam() throws IOException {
        String word = this.scan.next();
        VarType type = word.equals("Color") ? VarType.Vector4 : VarType.valueOf(word);
        word = this.readString("[\n;(//)(\\})]");
        FixedFuncBinding ffBinding = null;
        if (word.contains(":")) {
            String[] split = word.split(":");
            word = split[0].trim();
            try {
                ffBinding = FixedFuncBinding.valueOf(split[1].trim());
            }
            catch (IllegalArgumentException ex) {
                throw new IOException("FixedFuncBinding '" + split[1] + "' does not exist!");
            }
        }
        this.materialDef.addMaterialParam(type, word, null, ffBinding);
    }

    private void readValueParam() throws IOException {
        String name = this.readString(":");
        this.throwIfNequal(":", this.scan.next());
        MatParam p = this.material.getMaterialDef().getMaterialParam(name);
        if (p == null) {
            throw new IOException("The material parameter: " + name + " is undefined.");
        }
        VarType type = p.getVarType();
        if (type.isTextureType()) {
            String texturePath = this.readString("[\n;(\\})]");
            boolean flipY = false;
            boolean repeat = false;
            if (texturePath.startsWith("Flip Repeat ")) {
                texturePath = texturePath.substring(12).trim();
                flipY = true;
                repeat = true;
            } else if (texturePath.startsWith("Flip ")) {
                texturePath = texturePath.substring(5).trim();
                flipY = true;
            } else if (texturePath.startsWith("Repeat ")) {
                texturePath = texturePath.substring(7).trim();
                repeat = true;
            }
            TextureKey key = new TextureKey(texturePath, flipY);
            key.setAsCube(type == VarType.TextureCubeMap);
            key.setGenerateMips(true);
            Texture tex = this.owner.loadTexture(key);
            if (tex != null) {
                if (repeat) {
                    tex.setWrap(Texture.WrapMode.Repeat);
                }
                this.material.setTextureParam(name, type, tex);
            }
        } else {
            switch (type) {
                case Float: {
                    this.material.setParam(name, type, Float.valueOf(this.scan.nextFloat()));
                    break;
                }
                case Vector2: {
                    this.material.setParam(name, type, new Vector2f(this.scan.nextFloat(), this.scan.nextFloat()));
                    break;
                }
                case Vector3: {
                    this.material.setParam(name, type, new Vector3f(this.scan.nextFloat(), this.scan.nextFloat(), this.scan.nextFloat()));
                    break;
                }
                case Vector4: {
                    this.material.setParam(name, type, new ColorRGBA(this.scan.nextFloat(), this.scan.nextFloat(), this.scan.nextFloat(), this.scan.nextFloat()));
                    break;
                }
                case Int: {
                    this.material.setParam(name, type, this.scan.nextInt());
                    break;
                }
                case Boolean: {
                    this.material.setParam(name, type, this.scan.nextBoolean());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown type: " + (Object)((Object)type));
                }
            }
        }
    }

    private void readMaterialParams() throws IOException {
        this.nextStatement();
        String word = this.scan.next();
        this.throwIfNequal("{", word);
        this.nextStatement();
        while (true) {
            if (this.scan.hasNext("\\}")) break;
            this.readParam();
            this.nextStatement();
        }
        this.scan.next();
    }

    private void readExtendingMaterialParams() throws IOException {
        this.nextStatement();
        String word = this.scan.next();
        this.throwIfNequal("{", word);
        this.nextStatement();
        while (true) {
            if (this.scan.hasNext("\\}")) break;
            this.readValueParam();
            this.nextStatement();
        }
        this.scan.next();
    }

    private void readWorldParams() throws IOException {
        this.nextStatement();
        String word = this.scan.next();
        this.throwIfNequal("{", word);
        this.nextStatement();
        while (true) {
            if (this.scan.hasNext("\\}")) break;
            word = this.readString("[\n;(//)(\\})]");
            if (word != null && !word.equals("")) {
                this.technique.addWorldParam(word);
            }
            this.nextStatement();
        }
        this.scan.next();
    }

    private boolean parseBoolean(String word) {
        return word != null && word.equals("On");
    }

    private void readRenderStateStatement() throws IOException {
        String word = this.scan.next();
        if (word.equals("Wireframe")) {
            this.renderState.setWireframe(this.parseBoolean(this.scan.next()));
        } else if (word.equals("FaceCull")) {
            this.renderState.setFaceCullMode(RenderState.FaceCullMode.valueOf(this.scan.next()));
        } else if (word.equals("DepthWrite")) {
            this.renderState.setDepthWrite(this.parseBoolean(this.scan.next()));
        } else if (word.equals("DepthTest")) {
            this.renderState.setDepthTest(this.parseBoolean(this.scan.next()));
        } else if (word.equals("Blend")) {
            this.renderState.setBlendMode(RenderState.BlendMode.valueOf(this.scan.next()));
        } else if (word.equals("AlphaTestFalloff")) {
            this.renderState.setAlphaTest(true);
            this.renderState.setAlphaFallOff(this.scan.nextFloat());
        } else if (word.equals("PolyOffset")) {
            float factor = this.scan.nextFloat();
            float units = this.scan.nextFloat();
            this.renderState.setPolyOffset(factor, units);
        } else if (word.equals("ColorWrite")) {
            this.renderState.setColorWrite(this.parseBoolean(this.scan.next()));
        } else if (word.equals("PointSprite")) {
            this.renderState.setPointSprite(this.parseBoolean(this.scan.next()));
        } else {
            this.throwIfNequal(null, word);
        }
    }

    private void readAdditionalRenderState() throws IOException {
        this.nextStatement();
        String word = this.scan.next();
        this.throwIfNequal("{", word);
        this.nextStatement();
        this.renderState = this.material.getAdditionalRenderState();
        while (true) {
            if (this.scan.hasNext("\\}")) break;
            this.readRenderStateStatement();
            this.nextStatement();
        }
        this.scan.next();
        this.renderState = null;
    }

    private void readRenderState() throws IOException {
        this.nextStatement();
        String word = this.scan.next();
        this.throwIfNequal("{", word);
        this.nextStatement();
        this.renderState = new RenderState();
        while (true) {
            if (this.scan.hasNext("\\}")) break;
            this.readRenderStateStatement();
            this.nextStatement();
        }
        this.scan.next();
        this.technique.setRenderState(this.renderState);
        this.renderState = null;
    }

    private void readDefine() {
        String defineName = this.readString("[\n;:(//)(\\})]");
        if (defineName.equals("")) {
            return;
        }
        String matParamName = null;
        if (this.scan.hasNext(":")) {
            this.scan.next();
            matParamName = this.readString("[\n;(//)(\\})]");
            this.technique.addShaderParamDefine(matParamName, defineName);
        } else {
            this.technique.addShaderPresetDefine(defineName, VarType.Boolean, true);
        }
    }

    private void readDefines() throws IOException {
        this.nextStatement();
        String word = this.scan.next();
        this.throwIfNequal("{", word);
        this.nextStatement();
        while (true) {
            if (this.scan.hasNext("\\}")) break;
            this.readDefine();
            this.nextStatement();
        }
        this.scan.next();
    }

    private void readTechniqueStatement() throws IOException {
        String word = this.scan.next();
        if (word.equals("VertexShader")) {
            this.readShaderStatement(Shader.ShaderType.Vertex);
        } else if (word.equals("FragmentShader")) {
            this.readShaderStatement(Shader.ShaderType.Fragment);
        } else if (word.equals("LightMode")) {
            this.readLightMode();
        } else if (word.equals("ShadowMode")) {
            this.readShadowMode();
        } else if (word.equals("WorldParameters")) {
            this.readWorldParams();
        } else if (word.equals("RenderState")) {
            this.readRenderState();
        } else if (word.equals("Defines")) {
            this.readDefines();
        } else {
            this.throwIfNequal(null, word);
        }
        this.nextStatement();
    }

    private void readTransparentStatement() throws IOException {
        String on = this.readString("[\n;(\\})]");
        this.material.setTransparent(this.parseBoolean(on));
    }

    private void readTechnique() throws IOException {
        String name = null;
        if (!this.scan.hasNext("\\{")) {
            name = this.scan.next();
        }
        this.technique = new TechniqueDef(name);
        String word = this.scan.next();
        this.throwIfNequal("{", word);
        this.nextStatement();
        while (true) {
            if (this.scan.hasNext("\\}")) break;
            this.readTechniqueStatement();
        }
        this.scan.next();
        if (this.vertName != null && this.fragName != null) {
            this.technique.setShaderFile(this.vertName, this.fragName, this.shaderLang);
        }
        this.materialDef.addTechniqueDef(this.technique);
        this.technique = null;
        this.vertName = null;
        this.fragName = null;
        this.shaderLang = null;
    }

    private void loadFromScanner() throws IOException {
        block17: {
            this.nextStatement();
            boolean extending = false;
            String name = null;
            String word = this.scan.next();
            if (word.equals("Material")) {
                extending = true;
            } else if (word.equals("MaterialDef")) {
                extending = false;
            } else {
                if (word.equals("Exception")) {
                    String exception = this.scan.nextLine();
                    throw new AssetLoadException(exception);
                }
                throw new IOException("Specified file is not a Material file");
            }
            this.nextStatement();
            word = this.readString("[(\\{)(//)\n:]");
            if (word == null || word.equals("")) {
                throw new IOException("Material name cannot be empty");
            }
            name = word;
            this.nextStatement();
            if (this.scan.hasNext(":")) {
                if (!extending) {
                    throw new IOException("Must use 'Material' when extending.");
                }
                this.scan.next();
                String extendedMat = this.readString("\\{");
                MaterialDef def = (MaterialDef)this.owner.loadAsset(new AssetKey(extendedMat));
                if (def == null) {
                    throw new IOException("Extended material " + extendedMat + " cannot be found.");
                }
                this.material = new Material(def);
                this.material.setKey(this.key);
            } else if (this.scan.hasNext("\\{")) {
                if (extending) {
                    throw new IOException("Expected ':', got '{'");
                }
                this.materialDef = new MaterialDef(this.owner, name);
                this.materialDef.setAssetName(this.key.getName());
            }
            this.scan.next();
            this.nextStatement();
            while (true) {
                if (this.scan.hasNext("\\}")) break block17;
                word = this.scan.next();
                if (extending) {
                    if (word.equals("MaterialParameters")) {
                        this.readExtendingMaterialParams();
                        this.nextStatement();
                        continue;
                    }
                    if (word.equals("AdditionalRenderState")) {
                        this.readAdditionalRenderState();
                        this.nextStatement();
                        continue;
                    }
                    if (!word.equals("Transparent")) continue;
                    this.readTransparentStatement();
                    this.nextStatement();
                    continue;
                }
                if (word.equals("Technique")) {
                    this.readTechnique();
                    this.nextStatement();
                    continue;
                }
                if (!word.equals("MaterialParameters")) break;
                this.readMaterialParams();
                this.nextStatement();
            }
            throw new IOException("Expected material statement, got '" + this.scan.next() + "'");
        }
        this.scan.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(AssetInfo info) throws IOException {
        this.owner = info.getManager();
        InputStream in = info.openStream();
        try {
            this.scan = new Scanner(in);
            this.scan.useLocale(Locale.US);
            this.key = info.getKey();
            this.loadFromScanner();
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        if (this.material != null) {
            if (!(info.getKey() instanceof MaterialKey)) {
                throw new IOException("Material instances must be loaded via MaterialKey");
            }
            return this.material;
        }
        return this.materialDef;
    }
}

