/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.post.filters;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.post.Filter;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;

public class FXAAFilter
extends Filter {
    private float subPixelShif = 0.25f;
    private float vxOffset = 0.0f;
    private float spanMax = 8.0f;
    private float reduceMul = 0.125f;

    public FXAAFilter() {
        super("FXAAFilter");
    }

    protected void initFilter(AssetManager manager, RenderManager renderManager, ViewPort vp, int w, int h) {
        this.material = new Material(manager, "Common/MatDefs/Post/FXAA.j3md");
        this.material.setFloat("SubPixelShif", this.subPixelShif);
        this.material.setFloat("VxOffset", this.vxOffset);
        this.material.setFloat("SpanMax", this.spanMax);
        this.material.setFloat("ReduceMul", this.reduceMul);
    }

    protected Material getMaterial() {
        return this.material;
    }

    public void setSpanMax(float spanMax) {
        this.spanMax = spanMax;
        if (this.material != null) {
            this.material.setFloat("SpanMax", this.spanMax);
        }
    }

    public void setSubPixelShift(float subPixelShift) {
        this.subPixelShif = subPixelShift;
        if (this.material != null) {
            this.material.setFloat("SubPixelShif", this.subPixelShif);
        }
    }

    public void setReduceMul(float reduceMul) {
        this.reduceMul = reduceMul;
        if (this.material != null) {
            this.material.setFloat("ReduceMul", this.reduceMul);
        }
    }

    public void setVxOffset(float vxOffset) {
        this.vxOffset = vxOffset;
        if (this.material != null) {
            this.material.setFloat("VxOffset", this.vxOffset);
        }
    }

    public float getReduceMul() {
        return this.reduceMul;
    }

    public float getSpanMax() {
        return this.spanMax;
    }

    public float getSubPixelShif() {
        return this.subPixelShif;
    }

    public float getVxOffset() {
        return this.vxOffset;
    }
}

