/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene;

import com.jme3.asset.AssetNotFoundException;
import com.jme3.bounding.BoundingVolume;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResults;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.material.Material;
import com.jme3.math.Matrix4f;
import com.jme3.scene.Mesh;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.TempVars;
import java.io.IOException;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Geometry
extends Spatial {
    private static final Logger logger = Logger.getLogger(Geometry.class.getName());
    protected Mesh mesh;
    protected transient int lodLevel = 0;
    protected Material material;
    protected boolean ignoreTransform = false;
    protected transient Matrix4f cachedWorldMat = new Matrix4f();

    public Geometry() {
    }

    public Geometry(String name) {
        super(name);
    }

    public Geometry(String name, Mesh mesh) {
        this(name);
        if (mesh == null) {
            throw new NullPointerException();
        }
        this.mesh = mesh;
    }

    public boolean isIgnoreTransform() {
        return this.ignoreTransform;
    }

    public void setIgnoreTransform(boolean ignoreTransform) {
        this.ignoreTransform = ignoreTransform;
    }

    @Override
    public void setLodLevel(int lod) {
        if (this.mesh.getNumLodLevels() == 0) {
            throw new IllegalStateException("LOD levels are not set on this mesh");
        }
        if (lod < 0 || lod >= this.mesh.getNumLodLevels()) {
            throw new IllegalArgumentException("LOD level is out of range: " + lod);
        }
        this.lodLevel = lod;
    }

    public int getLodLevel() {
        return this.lodLevel;
    }

    @Override
    public int getVertexCount() {
        return this.mesh.getVertexCount();
    }

    @Override
    public int getTriangleCount() {
        return this.mesh.getTriangleCount();
    }

    public void setMesh(Mesh mesh) {
        if (mesh == null) {
            throw new IllegalArgumentException();
        }
        this.mesh = mesh;
        this.setBoundRefresh();
    }

    public Mesh getMesh() {
        return this.mesh;
    }

    @Override
    public void setMaterial(Material material) {
        this.material = material;
    }

    public Material getMaterial() {
        return this.material;
    }

    public BoundingVolume getModelBound() {
        return this.mesh.getBound();
    }

    @Override
    public void updateModelBound() {
        this.mesh.updateBound();
        this.setBoundRefresh();
    }

    @Override
    protected void updateWorldBound() {
        super.updateWorldBound();
        if (this.mesh == null) {
            throw new NullPointerException("Geometry: " + this.getName() + " has null mesh");
        }
        if (this.mesh.getBound() != null) {
            this.worldBound = this.ignoreTransform ? this.mesh.getBound().clone(this.worldBound) : this.mesh.getBound().transform(this.worldTransform, this.worldBound);
        }
    }

    @Override
    protected void updateWorldTransforms() {
        super.updateWorldTransforms();
        this.computeWorldMatrix();
        this.worldLights.sort(true);
    }

    public void computeWorldMatrix() {
        this.checkDoTransformUpdate();
        this.cachedWorldMat.loadIdentity();
        this.cachedWorldMat.setRotationQuaternion(this.worldTransform.getRotation());
        this.cachedWorldMat.setTranslation(this.worldTransform.getTranslation());
        TempVars vars = TempVars.get();
        Matrix4f scaleMat = vars.tempMat4;
        scaleMat.loadIdentity();
        scaleMat.scale(this.worldTransform.getScale());
        this.cachedWorldMat.multLocal(scaleMat);
        vars.release();
    }

    public Matrix4f getWorldMatrix() {
        return this.cachedWorldMat;
    }

    @Override
    public void setModelBound(BoundingVolume modelBound) {
        this.worldBound = null;
        this.mesh.setBound(modelBound);
        this.setBoundRefresh();
    }

    @Override
    public int collideWith(Collidable other, CollisionResults results) {
        this.checkDoBoundUpdate();
        this.computeWorldMatrix();
        assert ((this.refreshFlags & 3) == 0);
        if (this.mesh != null) {
            int prevSize = results.size();
            int added = this.mesh.collideWith(other, this.cachedWorldMat, this.worldBound, results);
            int newSize = results.size();
            for (int i = prevSize; i < newSize; ++i) {
                results.getCollisionDirect(i).setGeometry(this);
            }
            return added;
        }
        return 0;
    }

    @Override
    public void depthFirstTraversal(SceneGraphVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void breadthFirstTraversal(SceneGraphVisitor visitor, Queue<Spatial> queue) {
    }

    @Override
    public Geometry clone(boolean cloneMaterial) {
        Geometry geomClone = (Geometry)super.clone(cloneMaterial);
        geomClone.cachedWorldMat = this.cachedWorldMat.clone();
        if (this.material != null) {
            geomClone.material = cloneMaterial ? this.material.clone() : this.material;
        }
        if (this.mesh != null && this.mesh.getBuffer(VertexBuffer.Type.BindPosePosition) != null) {
            geomClone.mesh = this.mesh.cloneForAnim();
        }
        return geomClone;
    }

    @Override
    public Geometry clone() {
        return this.clone(true);
    }

    @Override
    public Spatial deepClone() {
        Geometry geomClone = this.clone(true);
        geomClone.mesh = this.mesh.deepClone();
        return geomClone;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.mesh, "mesh", null);
        if (this.material != null) {
            oc.write(this.material.getAssetName(), "materialName", null);
        }
        oc.write(this.material, "material", null);
        oc.write(this.ignoreTransform, "ignoreTransform", false);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.mesh = (Mesh)ic.readSavable("mesh", null);
        this.material = null;
        String matName = ic.readString("materialName", null);
        if (matName != null) {
            try {
                this.material = im.getAssetManager().loadMaterial(matName);
            }
            catch (AssetNotFoundException ex) {
                logger.log(Level.FINE, "Could not load J3M file {0} for Geometry.", matName);
            }
        }
        if (this.material == null) {
            this.material = (Material)ic.readSavable("material", null);
        }
        this.ignoreTransform = ic.readBoolean("ignoreTransform", false);
    }
}

