/*
 * Decompiled with CFR 0.152.
 */
package jme3tools.converters.model.strip;

import jme3tools.converters.model.strip.EdgeInfo;
import jme3tools.converters.model.strip.EdgeInfoVec;
import jme3tools.converters.model.strip.FaceInfo;
import jme3tools.converters.model.strip.FaceInfoVec;
import jme3tools.converters.model.strip.IntVec;
import jme3tools.converters.model.strip.StripStartInfo;
import jme3tools.converters.model.strip.Stripifier;

class StripInfo {
    StripStartInfo m_startInfo;
    FaceInfoVec m_faces = new FaceInfoVec();
    int m_stripId;
    int m_experimentId;
    boolean visited;
    int m_numDegenerates;

    public StripInfo(StripStartInfo startInfo, int stripId, int experimentId) {
        this.m_startInfo = startInfo;
        this.m_stripId = stripId;
        this.m_experimentId = experimentId;
        this.visited = false;
        this.m_numDegenerates = 0;
    }

    boolean isExperiment() {
        return this.m_experimentId >= 0;
    }

    boolean isInStrip(FaceInfo faceInfo) {
        if (faceInfo == null) {
            return false;
        }
        return this.m_experimentId >= 0 ? faceInfo.m_testStripId == this.m_stripId : faceInfo.m_stripId == this.m_stripId;
    }

    boolean isMarked(FaceInfo faceInfo) {
        return faceInfo.m_stripId >= 0 || this.isExperiment() && faceInfo.m_experimentId == this.m_experimentId;
    }

    void markTriangle(FaceInfo faceInfo) {
        if (this.isExperiment()) {
            faceInfo.m_experimentId = this.m_experimentId;
            faceInfo.m_testStripId = this.m_stripId;
        } else {
            faceInfo.m_experimentId = -1;
            faceInfo.m_stripId = this.m_stripId;
        }
    }

    boolean unique(FaceInfoVec faceVec, FaceInfo face) {
        boolean bv2 = false;
        boolean bv1 = false;
        boolean bv0 = false;
        for (int i = 0; i < faceVec.size(); ++i) {
            if (!(bv0 || faceVec.at((int)i).m_v0 != face.m_v0 && faceVec.at((int)i).m_v1 != face.m_v0 && faceVec.at((int)i).m_v2 != face.m_v0)) {
                bv0 = true;
            }
            if (!(bv1 || faceVec.at((int)i).m_v0 != face.m_v1 && faceVec.at((int)i).m_v1 != face.m_v1 && faceVec.at((int)i).m_v2 != face.m_v1)) {
                bv1 = true;
            }
            if (!(bv2 || faceVec.at((int)i).m_v0 != face.m_v2 && faceVec.at((int)i).m_v1 != face.m_v2 && faceVec.at((int)i).m_v2 != face.m_v2)) {
                bv2 = true;
            }
            if (!bv0 || !bv1 || !bv2) continue;
            return false;
        }
        return true;
    }

    void build(EdgeInfoVec edgeInfos, FaceInfoVec faceInfos) {
        IntVec scratchIndices = new IntVec();
        FaceInfoVec forwardFaces = new FaceInfoVec();
        FaceInfoVec backwardFaces = new FaceInfoVec();
        forwardFaces.add(this.m_startInfo.m_startFace);
        this.markTriangle(this.m_startInfo.m_startFace);
        int v0 = this.m_startInfo.m_toV1 ? this.m_startInfo.m_startEdge.m_v0 : this.m_startInfo.m_startEdge.m_v1;
        int v1 = this.m_startInfo.m_toV1 ? this.m_startInfo.m_startEdge.m_v1 : this.m_startInfo.m_startEdge.m_v0;
        scratchIndices.add(v0);
        scratchIndices.add(v1);
        int v2 = Stripifier.getNextIndex(scratchIndices, this.m_startInfo.m_startFace);
        scratchIndices.add(v2);
        int nv0 = v1;
        int nv1 = v2;
        FaceInfo nextFace = Stripifier.findOtherFace(edgeInfos, nv0, nv1, this.m_startInfo.m_startFace);
        while (nextFace != null && !this.isMarked(nextFace)) {
            FaceInfo testNextFace;
            int testnv0 = nv1;
            int testnv1 = Stripifier.getNextIndex(scratchIndices, nextFace);
            FaceInfo nextNextFace = Stripifier.findOtherFace(edgeInfos, testnv0, testnv1, nextFace);
            if ((nextNextFace == null || this.isMarked(nextNextFace)) && (testNextFace = Stripifier.findOtherFace(edgeInfos, nv0, testnv1, nextFace)) != null && !this.isMarked(testNextFace)) {
                FaceInfo tempFace = new FaceInfo(nv0, nv1, nv0);
                forwardFaces.add(tempFace);
                this.markTriangle(tempFace);
                scratchIndices.add(nv0);
                testnv0 = nv0;
                ++this.m_numDegenerates;
            }
            forwardFaces.add(nextFace);
            this.markTriangle(nextFace);
            scratchIndices.add(testnv1);
            nv0 = testnv0;
            nv1 = testnv1;
            nextFace = Stripifier.findOtherFace(edgeInfos, nv0, nv1, nextFace);
        }
        FaceInfoVec tempAllFaces = new FaceInfoVec();
        for (int i = 0; i < forwardFaces.size(); ++i) {
            tempAllFaces.add(forwardFaces.at(i));
        }
        scratchIndices.clear();
        scratchIndices.add(v2);
        scratchIndices.add(v1);
        scratchIndices.add(v0);
        nv0 = v1;
        nv1 = v0;
        nextFace = Stripifier.findOtherFace(edgeInfos, nv0, nv1, this.m_startInfo.m_startFace);
        while (nextFace != null && !this.isMarked(nextFace) && this.unique(tempAllFaces, nextFace)) {
            FaceInfo testNextFace;
            int testnv0 = nv1;
            int testnv1 = Stripifier.getNextIndex(scratchIndices, nextFace);
            FaceInfo nextNextFace = Stripifier.findOtherFace(edgeInfos, testnv0, testnv1, nextFace);
            if ((nextNextFace == null || this.isMarked(nextNextFace)) && (testNextFace = Stripifier.findOtherFace(edgeInfos, nv0, testnv1, nextFace)) != null && !this.isMarked(testNextFace)) {
                FaceInfo tempFace = new FaceInfo(nv0, nv1, nv0);
                backwardFaces.add(tempFace);
                this.markTriangle(tempFace);
                scratchIndices.add(nv0);
                testnv0 = nv0;
                ++this.m_numDegenerates;
            }
            backwardFaces.add(nextFace);
            tempAllFaces.add(nextFace);
            this.markTriangle(nextFace);
            scratchIndices.add(testnv1);
            nv0 = testnv0;
            nv1 = testnv1;
            nextFace = Stripifier.findOtherFace(edgeInfos, nv0, nv1, nextFace);
        }
        this.combine(forwardFaces, backwardFaces);
    }

    void combine(FaceInfoVec forward, FaceInfoVec backward) {
        int i;
        int numFaces = backward.size();
        for (i = numFaces - 1; i >= 0; --i) {
            this.m_faces.add(backward.at(i));
        }
        numFaces = forward.size();
        for (i = 0; i < numFaces; ++i) {
            this.m_faces.add(forward.at(i));
        }
    }

    boolean sharesEdge(FaceInfo faceInfo, EdgeInfoVec edgeInfos) {
        EdgeInfo currEdge = Stripifier.findEdgeInfo(edgeInfos, faceInfo.m_v0, faceInfo.m_v1);
        if (this.isInStrip(currEdge.m_face0) || this.isInStrip(currEdge.m_face1)) {
            return true;
        }
        currEdge = Stripifier.findEdgeInfo(edgeInfos, faceInfo.m_v1, faceInfo.m_v2);
        if (this.isInStrip(currEdge.m_face0) || this.isInStrip(currEdge.m_face1)) {
            return true;
        }
        currEdge = Stripifier.findEdgeInfo(edgeInfos, faceInfo.m_v2, faceInfo.m_v0);
        return this.isInStrip(currEdge.m_face0) || this.isInStrip(currEdge.m_face1);
    }
}

