/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.jme3.mmd;

import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.control.BillboardControl;
import com.jme3.scene.debug.SkeletonWire;
import com.jme3.scene.shape.Box;
import com.jme3.shader.VarType;
import com.jme3.util.TempVars;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Tuple3f;
import projectkyoto.jme3.mmd.PMDGeometry;
import projectkyoto.jme3.mmd.PMDMesh;
import projectkyoto.jme3.mmd.PMDSkinMesh;
import projectkyoto.jme3.mmd.RigidBodyConverter;
import projectkyoto.jme3.mmd.Skin;
import projectkyoto.mmd.file.PMDBone;
import projectkyoto.mmd.file.PMDException;
import projectkyoto.mmd.file.PMDModel;
import projectkyoto.mmd.file.PMDSkinVertData;
import projectkyoto.mmd.file.PMDVertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMDNode
extends Node {
    PMDModel pmdModel;
    Skeleton skeleton;
    PMDMesh[] targets;
    PMDSkinMesh[] skinTargets;
    Map<String, Skin> skinMap = new HashMap<String, Skin>();
    javax.vecmath.Vector3f[] skinPosArray;
    javax.vecmath.Vector3f[] skinNormalArray;
    javax.vecmath.Vector3f[] skinPosArrayOrig;
    javax.vecmath.Vector3f[] skinNormalArrayOrig;
    float[] skinBoneWeightArray;
    int[] skinBoneArray;
    AssetManager assetManager;
    Matrix4f[] offsetMatrices;
    boolean updateNeeded = true;
    boolean skinUpdateNeeded = true;
    boolean wireFrame = false;
    float edgeSize = 1.0f;
    boolean skeletonWireVisible = false;
    Geometry skeletonWireGeom;
    boolean bonePositionVisible = false;
    Node bonePositionNode;
    Geometry[] bonePositionGeomArray;
    Node rigidBodyNode;
    Node jointNode;
    boolean glslSkinning = true;

    public PMDNode(String name, PMDModel pmdModel, AssetManager assetManager) {
        super(name);
        this.pmdModel = pmdModel;
        this.assetManager = assetManager;
    }

    public PMDNode() {
    }

    public void init() {
        this.initMaterials();
        this.resetToBind();
    }

    void setSkinData(PMDSkinMesh[] skinTargets, List<PMDVertex> skinVertexList, Skin[] skinAray) {
        this.skinTargets = skinTargets;
        for (Skin skin : skinAray) {
            this.skinMap.put(skin.getSkinName(), skin);
        }
        int skinVertSize = skinVertexList.size();
        this.skinPosArray = new javax.vecmath.Vector3f[skinVertSize];
        this.skinNormalArray = new javax.vecmath.Vector3f[skinVertSize];
        this.skinPosArrayOrig = new javax.vecmath.Vector3f[skinVertSize];
        this.skinNormalArrayOrig = new javax.vecmath.Vector3f[skinVertSize];
        this.skinBoneWeightArray = new float[skinVertSize];
        this.skinBoneArray = new int[skinVertSize * 2];
        for (int i = 0; i < skinVertSize; ++i) {
            PMDVertex v = skinVertexList.get(i);
            this.skinPosArrayOrig[i] = v.getPos();
            this.skinPosArray[i] = new javax.vecmath.Vector3f(v.getPos());
            this.skinNormalArrayOrig[i] = v.getNormal();
            this.skinNormalArray[i] = new javax.vecmath.Vector3f(v.getNormal());
            this.skinBoneWeightArray[i] = (float)v.getBoneWeight() / 100.0f;
            this.skinBoneArray[i * 2] = v.getBoneNum1();
            this.skinBoneArray[i * 2 + 1] = v.getBoneNum2();
        }
    }

    public PMDModel getPmdModel() {
        return this.pmdModel;
    }

    public void setPmdModel(PMDModel pmdModel) {
        this.pmdModel = pmdModel;
    }

    public Matrix4f[] calcOffsetMatrices() {
        this.offsetMatrices = this.skeleton.computeSkinningMatrices();
        return this.offsetMatrices;
    }

    public void update() {
        this.updateNeeded = false;
        this.offsetMatrices = this.skeleton.computeSkinningMatrices();
        for (Spatial s : this.getChildren()) {
            if (!(s instanceof Geometry)) continue;
            Geometry g = (Geometry)s;
            Material m = g.getMaterial();
            if (!(g.getMesh() instanceof PMDMesh)) continue;
            PMDMesh pmdMesh = (PMDMesh)g.getMesh();
            for (int i = 0; i < pmdMesh.getBoneIndexArray().length; ++i) {
                pmdMesh.getBoneMatrixArray()[i].set(this.offsetMatrices[pmdMesh.getBoneIndexArray()[i]]);
            }
            if (!this.glslSkinning) continue;
            m.setParam("BoneMatrices", VarType.Matrix4Array, pmdMesh.getBoneMatrixArray());
        }
        if (!this.glslSkinning) {
            for (PMDMesh mesh : this.targets) {
                this.softwareSkinUpdate(mesh);
            }
        }
        this.swapSkinMesh();
        if (this.skeletonWireGeom != null) {
            ((SkeletonWire)this.skeletonWireGeom.getMesh()).updateGeometry();
        }
        if (this.bonePositionVisible) {
            for (int i = 0; i < this.bonePositionGeomArray.length; ++i) {
                Geometry bonePosGeom = this.bonePositionGeomArray[i];
                Bone bone = this.skeleton.getBone(i);
                Vector3f bonePos = bone.getModelSpacePosition();
                bonePosGeom.setLocalTranslation(bonePos);
            }
        }
    }

    private void swapSkinMesh() {
        VertexBuffer vb = this.skinTargets[0].getBuffer(VertexBuffer.Type.Position);
        VertexBuffer nb = this.skinTargets[0].getBuffer(VertexBuffer.Type.Normal);
        this.skinTargets[0].skinvb2.setUpdateNeeded();
        this.skinTargets[0].skinnb2.setUpdateNeeded();
        for (PMDSkinMesh skinMesh : this.skinTargets) {
            skinMesh.clearBuffer(VertexBuffer.Type.Position);
            skinMesh.clearBuffer(VertexBuffer.Type.Normal);
            skinMesh.setBuffer(this.skinTargets[0].getSkinvb2());
            skinMesh.setBuffer(this.skinTargets[0].getSkinnb2());
        }
        this.skinTargets[0].skinvb2 = vb;
        this.skinTargets[0].skinnb2 = nb;
        vb = this.skinTargets[0].getBuffer(VertexBuffer.Type.Position);
        nb = this.skinTargets[0].getBuffer(VertexBuffer.Type.Normal);
        vb.setUpdateNeeded();
        nb.setUpdateNeeded();
    }

    private void softwareSkinUpdate(PMDMesh mesh) {
        int maxWeightsPerVert = 2;
        int fourMinusMaxWeights = 4 - maxWeightsPerVert;
        this.resetToBind(mesh);
        VertexBuffer vb = mesh.getBuffer(VertexBuffer.Type.Position);
        FloatBuffer fvb = (FloatBuffer)vb.getData();
        fvb.rewind();
        VertexBuffer nb = mesh.getBuffer(VertexBuffer.Type.Normal);
        FloatBuffer fnb = (FloatBuffer)nb.getData();
        fnb.rewind();
        ShortBuffer ib = (ShortBuffer)mesh.getBuffer(VertexBuffer.Type.BoneIndex).getData();
        FloatBuffer wb = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.BoneWeight).getData();
        ib.rewind();
        wb.rewind();
        int idxWeights = 0;
        TempVars vars = TempVars.get();
        float[] posBuf = vars.skinPositions;
        float[] normBuf = vars.skinNormals;
        int iterations = (int)FastMath.ceil((float)fvb.capacity() / (float)posBuf.length);
        int bufLength = posBuf.length * 3;
        for (int i = iterations - 1; i >= 0; --i) {
            bufLength = Math.min(posBuf.length, fvb.remaining());
            fvb.get(posBuf, 0, bufLength);
            fnb.get(normBuf, 0, bufLength);
            int verts = bufLength / 3;
            int idxPositions = 0;
            for (int vert = verts - 1; vert >= 0; --vert) {
                float nmx = normBuf[idxPositions];
                float vtx = posBuf[idxPositions++];
                float nmy = normBuf[idxPositions];
                float vty = posBuf[idxPositions++];
                float nmz = normBuf[idxPositions];
                float vtz = posBuf[idxPositions++];
                float rx = 0.0f;
                float ry = 0.0f;
                float rz = 0.0f;
                float rnx = 0.0f;
                float rny = 0.0f;
                float rnz = 0.0f;
                for (int w = maxWeightsPerVert - 1; w >= 0; --w) {
                    float weight = wb.get(idxWeights);
                    Matrix4f mat = mesh.getBoneMatrixArray()[ib.get(idxWeights++)];
                    rx += (mat.m00 * vtx + mat.m01 * vty + mat.m02 * vtz + mat.m03) * weight;
                    ry += (mat.m10 * vtx + mat.m11 * vty + mat.m12 * vtz + mat.m13) * weight;
                    rz += (mat.m20 * vtx + mat.m21 * vty + mat.m22 * vtz + mat.m23) * weight;
                    rnx += (nmx * mat.m00 + nmy * mat.m01 + nmz * mat.m02) * weight;
                    rny += (nmx * mat.m10 + nmy * mat.m11 + nmz * mat.m12) * weight;
                    rnz += (nmx * mat.m20 + nmy * mat.m21 + nmz * mat.m22) * weight;
                }
                idxWeights += fourMinusMaxWeights;
                normBuf[idxPositions -= 3] = rnx;
                posBuf[idxPositions++] = rx;
                normBuf[idxPositions] = rny;
                posBuf[idxPositions++] = ry;
                normBuf[idxPositions] = rnz;
                posBuf[idxPositions++] = rz;
            }
            fvb.position(fvb.position() - bufLength);
            fvb.put(posBuf, 0, bufLength);
            fnb.position(fnb.position() - bufLength);
            fnb.put(normBuf, 0, bufLength);
        }
        vb.setUpdateNeeded();
        nb.setUpdateNeeded();
        vars.release();
    }

    public void updateSkinBackData() {
        PMDSkinMesh skinMesh = this.skinTargets[0];
        VertexBuffer vb = skinMesh.getSkinvb2();
        FloatBuffer fvb = (FloatBuffer)vb.getData();
        VertexBuffer nb = skinMesh.getSkinnb2();
        FloatBuffer fnb = (FloatBuffer)nb.getData();
        for (Skin skin : this.skinMap.values()) {
            if (skin.getWeight() != 0.0f) {
                for (PMDSkinVertData svd : skin.getSkinData().getSkinVertData()) {
                    javax.vecmath.Vector3f dist = this.skinPosArray[svd.getSkinVertIndex()];
                    dist.set((Tuple3f)svd.getSkinVertPos());
                    dist.scale(skin.getWeight());
                    dist.add((Tuple3f)this.skinPosArrayOrig[svd.getSkinVertIndex()]);
                }
            }
            skin.setUpdateNeeded(false);
        }
        fvb.position(0);
        fnb.position(0);
        TempVars vars = TempVars.get();
        for (int i = 0; i < this.skinPosArray.length; ++i) {
            boolean idxWeights = false;
            float[] posBuf = vars.skinPositions;
            float[] normBuf = vars.skinNormals;
            boolean idxPositions = false;
            float nmx = this.skinNormalArray[i].x;
            float vtx = this.skinPosArray[i].x;
            float nmy = this.skinNormalArray[i].y;
            float vty = this.skinPosArray[i].y;
            float nmz = this.skinNormalArray[i].z;
            float vtz = this.skinPosArray[i].z;
            float rx = 0.0f;
            float ry = 0.0f;
            float rz = 0.0f;
            float rnx = 0.0f;
            float rny = 0.0f;
            float rnz = 0.0f;
            for (int w = 1; w >= 0; --w) {
                float weight = this.skinBoneWeightArray[i];
                if (w == 1) {
                    weight = 1.0f - weight;
                }
                Matrix4f mat = this.offsetMatrices[this.skinBoneArray[i * 2 + w]];
                rx += (mat.m00 * vtx + mat.m01 * vty + mat.m02 * vtz + mat.m03) * weight;
                ry += (mat.m10 * vtx + mat.m11 * vty + mat.m12 * vtz + mat.m13) * weight;
                rz += (mat.m20 * vtx + mat.m21 * vty + mat.m22 * vtz + mat.m23) * weight;
                rnx += (nmx * mat.m00 + nmy * mat.m01 + nmz * mat.m02) * weight;
                rny += (nmx * mat.m10 + nmy * mat.m11 + nmz * mat.m12) * weight;
                rnz += (nmx * mat.m20 + nmy * mat.m21 + nmz * mat.m22) * weight;
            }
            fnb.put(rnx).put(rny).put(rnz);
            fvb.put(rx).put(ry).put(rz);
        }
        vars.release();
        vb.setUpdateNeeded();
        nb.setUpdateNeeded();
        this.skinUpdateNeeded = false;
    }

    void updateSkinMesh(PMDSkinMesh skinMesh) {
        VertexBuffer vb = skinMesh.getBuffer(VertexBuffer.Type.Position);
        FloatBuffer fvb = (FloatBuffer)vb.getData();
        VertexBuffer nb = skinMesh.getBuffer(VertexBuffer.Type.Normal);
        FloatBuffer fnb = (FloatBuffer)nb.getData();
        for (Skin skin : this.skinMap.values()) {
            if (!skin.isUpdateNeeded()) continue;
            if (skin.getWeight() != 1.0f) {
                for (PMDSkinVertData svd : skin.getSkinData().getSkinVertData()) {
                    javax.vecmath.Vector3f dist = this.skinPosArray[svd.getSkinVertIndex()];
                    dist.set((Tuple3f)svd.getSkinVertPos());
                    dist.scale(skin.getWeight());
                    dist.add((Tuple3f)this.skinPosArrayOrig[svd.getSkinVertIndex()]);
                }
            }
            skin.setUpdateNeeded(false);
        }
        fvb.position(0);
        fnb.position(0);
        TempVars vars = TempVars.get();
        for (int i = 0; i < this.skinPosArray.length; ++i) {
            boolean idxWeights = false;
            float[] posBuf = vars.skinPositions;
            float[] normBuf = vars.skinNormals;
            boolean idxPositions = false;
            float nmx = this.skinNormalArray[i].x;
            float vtx = this.skinPosArray[i].x;
            float nmy = this.skinNormalArray[i].y;
            float vty = this.skinPosArray[i].y;
            float nmz = this.skinNormalArray[i].z;
            float vtz = this.skinPosArray[i].z;
            float rx = 0.0f;
            float ry = 0.0f;
            float rz = 0.0f;
            float rnx = 0.0f;
            float rny = 0.0f;
            float rnz = 0.0f;
            for (int w = 1; w >= 0; --w) {
                float weight = this.skinBoneWeightArray[i];
                if (w == 1) {
                    weight = 1.0f - weight;
                }
                Matrix4f mat = this.offsetMatrices[this.skinBoneArray[i * 2 + w]];
                rx += (mat.m00 * vtx + mat.m01 * vty + mat.m02 * vtz + mat.m03) * weight;
                ry += (mat.m10 * vtx + mat.m11 * vty + mat.m12 * vtz + mat.m13) * weight;
                rz += (mat.m20 * vtx + mat.m21 * vty + mat.m22 * vtz + mat.m23) * weight;
                rnx += (nmx * mat.m00 + nmy * mat.m01 + nmz * mat.m02) * weight;
                rny += (nmx * mat.m10 + nmy * mat.m11 + nmz * mat.m12) * weight;
                rnz += (nmx * mat.m20 + nmy * mat.m21 + nmz * mat.m22) * weight;
            }
            fnb.put(rnx).put(rny).put(rnz);
            fvb.put(rx).put(ry).put(rz);
        }
        vars.release();
        vb.setUpdateNeeded();
        nb.setUpdateNeeded();
    }

    public void resetToBind() {
        for (int i = 0; i < this.skeleton.getBoneCount(); ++i) {
            Bone bone = this.skeleton.getBone(i);
            PMDBone pmdBone = this.pmdModel.getBoneList().getBones()[i];
            if (pmdBone.getParentBoneIndex() < this.skeleton.getBoneCount()) {
                Bone parentBone = this.skeleton.getBone(pmdBone.getParentBoneIndex());
                PMDBone parentPMDBone = this.pmdModel.getBoneList().getBones()[pmdBone.getParentBoneIndex()];
                Vector3f v1 = new Vector3f();
                Vector3f v2 = new Vector3f();
                v1.set(pmdBone.getBoneHeadPos().x, pmdBone.getBoneHeadPos().y, pmdBone.getBoneHeadPos().z);
                v2.set(parentPMDBone.getBoneHeadPos().x, parentPMDBone.getBoneHeadPos().y, parentPMDBone.getBoneHeadPos().z);
                v1.subtractLocal(v2);
                bone.setBindTransforms(v1, Quaternion.IDENTITY, new Vector3f(1.0f, 1.0f, 1.0f));
                continue;
            }
            Vector3f v1 = new Vector3f();
            v1.set(pmdBone.getBoneHeadPos().x, pmdBone.getBoneHeadPos().y, pmdBone.getBoneHeadPos().z);
            bone.setBindTransforms(v1, Quaternion.IDENTITY, new Vector3f(1.0f, 1.0f, 1.0f));
        }
        for (PMDMesh mesh : this.targets) {
            this.resetToBind(mesh);
        }
        for (Skin skin : this.skinMap.values()) {
            skin.setWeight(0.0f);
        }
        this.setUpdateNeeded(true);
    }

    void resetToBind(PMDMesh mesh) {
    }

    void _resetToBind(PMDMesh mesh) {
        int i;
        VertexBuffer vb = mesh.getBuffer(VertexBuffer.Type.Position);
        FloatBuffer vfb = (FloatBuffer)vb.getData();
        VertexBuffer nb = mesh.getBuffer(VertexBuffer.Type.Normal);
        FloatBuffer nfb = (FloatBuffer)nb.getData();
        VertexBuffer bvb = mesh.getBuffer(VertexBuffer.Type.BindPosePosition);
        FloatBuffer bvfb = (FloatBuffer)bvb.getData();
        VertexBuffer bnb = mesh.getBuffer(VertexBuffer.Type.BindPoseNormal);
        FloatBuffer bnfb = (FloatBuffer)bnb.getData();
        for (i = 0; i < vfb.capacity(); ++i) {
            vfb.put(i, bvfb.get(i));
        }
        for (i = 0; i < nfb.capacity(); ++i) {
            nfb.put(i, bnfb.get(i));
        }
        vb.setUpdateNeeded();
        nb.setUpdateNeeded();
    }

    void resetToBindSkinBackData(PMDSkinMesh mesh) {
        int i;
        VertexBuffer vb = mesh.getSkinvb2();
        FloatBuffer vfb = (FloatBuffer)vb.getData();
        VertexBuffer nb = mesh.getSkinnb2();
        FloatBuffer nfb = (FloatBuffer)nb.getData();
        VertexBuffer bvb = mesh.getBuffer(VertexBuffer.Type.BindPosePosition);
        FloatBuffer bvfb = (FloatBuffer)bvb.getData();
        VertexBuffer bnb = mesh.getBuffer(VertexBuffer.Type.BindPoseNormal);
        FloatBuffer bnfb = (FloatBuffer)bnb.getData();
        for (i = 0; i < vfb.capacity(); ++i) {
            vfb.put(i, bvfb.get(i));
        }
        for (i = 0; i < nfb.capacity(); ++i) {
            nfb.put(i, bnfb.get(i));
        }
        vb.setUpdateNeeded();
        nb.setUpdateNeeded();
    }

    public Set<String> getSkinSet() {
        return this.skinMap.keySet();
    }

    public float getSkinWeight(String skinName) {
        return this.skinMap.get(skinName).getWeight();
    }

    public void setSkinWeight(String skinName, float weight) {
        Skin skin = this.skinMap.get(skinName);
        if (skin != null) {
            skin.setWeight(weight);
            this.skinUpdateNeeded = true;
        }
    }

    public boolean isUpdateNeeded() {
        return this.updateNeeded;
    }

    public void setUpdateNeeded(boolean updateNeeded) {
        this.updateNeeded = updateNeeded;
    }

    public Skeleton getSkeleton() {
        return this.skeleton;
    }

    public void setSkeleton(Skeleton skeleton) {
        this.skeleton = skeleton;
    }

    public void setWireFrame(boolean wireFrame) {
        for (Spatial sp : this.getChildren()) {
            if (!(sp instanceof Geometry)) continue;
            Geometry geom = (Geometry)sp;
            geom.getMaterial().getAdditionalRenderState().setWireframe(wireFrame);
        }
        this.wireFrame = wireFrame;
    }

    public boolean isWireFrame() {
        return this.wireFrame;
    }

    public void setEdgeWidth(float edgeSize) {
        for (Spatial sp : this.getChildren()) {
            PMDGeometry geom;
            if (!(sp instanceof PMDGeometry) || (geom = (PMDGeometry)sp).getPmdMaterial().getEdgeFlag() == 0) continue;
            geom.getMaterial().setFloat("EdgeSize", edgeSize);
        }
        this.edgeSize = edgeSize;
    }

    public void setSkeletonWireVisible(boolean skeletonWireVisible) {
        if (skeletonWireVisible) {
            if (this.skeletonWireGeom == null) {
                SkeletonWire skeletonWire = new SkeletonWire(this.skeleton);
                this.skeletonWireGeom = new Geometry("skeletonWire", skeletonWire);
                Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
                mat.setColor("Color", ColorRGBA.Green);
                mat.getAdditionalRenderState().setDepthTest(false);
                mat.getAdditionalRenderState().setDepthWrite(false);
                this.skeletonWireGeom.setMaterial(mat);
                this.skeletonWireGeom.setQueueBucket(RenderQueue.Bucket.Transparent);
                this.attachChild(this.skeletonWireGeom);
                skeletonWire.updateGeometry();
            }
        } else if (this.skeletonWireGeom != null) {
            this.skeletonWireGeom.removeFromParent();
            this.skeletonWireGeom = null;
        }
        this.skeletonWireVisible = skeletonWireVisible;
    }

    public void setBonePositionVisible(boolean bonePositionVisible) {
        if (bonePositionVisible) {
            if (this.bonePositionNode == null) {
                this.bonePositionNode = new Node("bonePositionNode");
                this.bonePositionGeomArray = new Geometry[this.pmdModel.getBoneList().getBoneCount()];
                Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
                mat.setColor("Color", ColorRGBA.Red);
                mat.getAdditionalRenderState().setDepthTest(false);
                mat.getAdditionalRenderState().setDepthWrite(false);
                Material mat2 = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
                mat2.setColor("Color", ColorRGBA.Blue);
                mat2.getAdditionalRenderState().setDepthTest(false);
                mat2.getAdditionalRenderState().setDepthWrite(false);
                Material mat3 = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
                mat3.setColor("Color", ColorRGBA.Green);
                mat3.getAdditionalRenderState().setDepthTest(false);
                mat3.getAdditionalRenderState().setDepthWrite(false);
                for (int i = 0; i < this.bonePositionGeomArray.length; ++i) {
                    Mesh mesh = new Mesh();
                    Geometry geom = new Geometry(this.pmdModel.getBoneList().getBones()[i].getBoneName(), new Box(0.1f, 0.1f, 0.0f));
                    geom.setMaterial(mat);
                    geom.setQueueBucket(RenderQueue.Bucket.Transparent);
                    this.bonePositionGeomArray[i] = geom;
                    this.bonePositionNode.attachChild(geom);
                    geom.addControl(new BillboardControl());
                    if (this.pmdModel.getBoneList().getBones()[i].getBoneType() == 2) {
                        geom.setMaterial(mat2);
                    }
                    if (this.pmdModel.getBoneList().getBones()[i].getBoneType() != 6) continue;
                    geom.setMaterial(mat3);
                }
                this.attachChild(this.bonePositionNode);
            }
        } else if (this.bonePositionNode != null) {
            this.bonePositionNode.removeFromParent();
            this.bonePositionNode = null;
            this.bonePositionGeomArray = null;
        }
        this.setUpdateNeeded(true);
        this.bonePositionVisible = bonePositionVisible;
    }

    public Node getBonePositionNode() {
        return this.bonePositionNode;
    }

    public Matrix4f[] getOffsetMatrices() {
        return this.offsetMatrices;
    }

    public void setRigidBodyVisible(boolean flag) {
        if (flag) {
            if (this.rigidBodyNode != null) {
                return;
            }
            RigidBodyConverter rbc = new RigidBodyConverter(this.pmdModel, this.assetManager);
            this.rigidBodyNode = rbc.convert("rigidBody");
            this.attachChild(this.rigidBodyNode);
        } else if (this.rigidBodyNode != null) {
            this.detachChild(this.rigidBodyNode);
            this.rigidBodyNode = null;
        }
    }

    public Node getRigidBodyNode() {
        return this.rigidBodyNode;
    }

    void initMaterials() {
        for (Spatial sp : this.getChildren()) {
            PMDGeometry geom;
            Mesh mesh;
            if (!(sp instanceof PMDGeometry) || !((mesh = (geom = (PMDGeometry)sp).getMesh()) instanceof PMDMesh)) continue;
            if (this.glslSkinning) {
                geom.setMaterial(geom.getGlslSkinningMaterial());
                continue;
            }
            geom.setMaterial(geom.getNoSkinningMaterial());
        }
    }

    public Node getJointNode() {
        return this.jointNode;
    }

    public void setJointNode(Node jointNode) {
        this.jointNode = jointNode;
    }

    public boolean isGlslSkinning() {
        return this.glslSkinning;
    }

    public void setGlslSkinning(boolean glslSkinning) {
        this.glslSkinning = glslSkinning = true;
        for (PMDMesh mesh : this.targets) {
        }
        for (Spatial sp : this.getChildren()) {
            Mesh mesh;
            if (!(sp instanceof PMDGeometry) || !((mesh = ((PMDGeometry)sp).getMesh()) instanceof PMDMesh)) continue;
            this.resetToBind((PMDMesh)mesh);
            if (glslSkinning) {
                mesh.getBuffer(VertexBuffer.Type.Position).setUsage(VertexBuffer.Usage.Static);
                mesh.getBuffer(VertexBuffer.Type.Normal).setUsage(VertexBuffer.Usage.Static);
                continue;
            }
            mesh.getBuffer(VertexBuffer.Type.Position).setUsage(VertexBuffer.Usage.Dynamic);
            mesh.getBuffer(VertexBuffer.Type.Normal).setUsage(VertexBuffer.Usage.Dynamic);
        }
        this.initMaterials();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return this.pmdModel.getModelName().hashCode();
    }

    @Override
    public PMDNode clone() {
        try {
            int i;
            PMDNode newPMDNode = (PMDNode)super.clone();
            System.out.println("model name = " + this.pmdModel.getModelName());
            System.out.println("child size = " + this.getChildren().size());
            System.out.println("source targets size = " + this.targets.length + " " + this.skinTargets.length);
            if (newPMDNode.getChildren().size() != this.getChildren().size()) {
                System.out.println("child size error " + newPMDNode.getChildren().size());
            }
            newPMDNode.skeleton = new Skeleton(this.skeleton);
            for (int i2 = 0; i2 < this.skeleton.getBoneCount(); ++i2) {
                Bone newBone = newPMDNode.skeleton.getBone(i2);
                Bone bone = this.skeleton.getBone(i2);
                newBone.getLocalPosition().set(bone.getLocalPosition());
                newBone.getLocalRotation().set(bone.getLocalRotation());
                newBone.getLocalScale().set(bone.getLocalScale());
            }
            newPMDNode.targets = new PMDMesh[this.targets.length];
            newPMDNode.skinTargets = new PMDSkinMesh[this.skinTargets.length];
            int meshCount = 0;
            int skinMeshCount = 0;
            Iterator<Object> i$ = newPMDNode.getChildren().iterator();
            while (i$.hasNext()) {
                Spatial sp;
                Spatial newSp = sp = i$.next();
                if (!(sp instanceof PMDGeometry)) continue;
                Mesh mesh = ((Geometry)newSp).getMesh();
                if (mesh instanceof PMDMesh) {
                    newPMDNode.targets[meshCount++] = (PMDMesh)mesh;
                    continue;
                }
                if (!(mesh instanceof PMDSkinMesh)) continue;
                newPMDNode.skinTargets[skinMeshCount++] = (PMDSkinMesh)mesh;
            }
            newPMDNode.skinMap = new HashMap<String, Skin>();
            for (String skinName : this.skinMap.keySet()) {
                Skin skin = this.skinMap.get(skinName);
                skin = skin.clone();
                newPMDNode.skinMap.put(skinName, skin);
            }
            newPMDNode.skinPosArray = new javax.vecmath.Vector3f[this.skinPosArray.length];
            for (i = 0; i < this.skinPosArray.length; ++i) {
                newPMDNode.skinPosArray[i] = new javax.vecmath.Vector3f(this.skinPosArray[i]);
            }
            newPMDNode.skinNormalArray = new javax.vecmath.Vector3f[this.skinNormalArray.length];
            for (i = 0; i < this.skinNormalArray.length; ++i) {
                newPMDNode.skinNormalArray[i] = new javax.vecmath.Vector3f(this.skinNormalArray[i]);
            }
            System.out.println("skinTargets size = " + this.skinTargets.length + " " + skinMeshCount);
            newPMDNode.setGlslSkinning(newPMDNode.glslSkinning);
            newPMDNode.skeleton.updateWorldVectors();
            newPMDNode.calcOffsetMatrices();
            newPMDNode.update();
            return newPMDNode;
        }
        catch (CloneNotSupportedException ex) {
            throw new PMDException(ex);
        }
    }
}

