/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.jme3.mmd.nativebullet;

import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.shapes.BoxCollisionShape;
import com.jme3.bullet.collision.shapes.CapsuleCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.SphereCollisionShape;
import com.jme3.bullet.joints.SixDofJoint;
import com.jme3.bullet.joints.SixDofSpringJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.math.Matrix3f;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Line;
import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Quat4f;
import projectkyoto.jme3.mmd.PMDNode;
import projectkyoto.jme3.mmd.nativebullet.PMDRigidBody;
import projectkyoto.mmd.file.PMDException;
import projectkyoto.mmd.file.PMDJoint;
import projectkyoto.mmd.file.PMDModel;

public class PMDPhysicsWorld {
    static final Object lockObject = new Object();
    PhysicsSpace physicsSpace;
    Map<PMDNode, PMDRigidBody[]> rigidBodyMap = new HashMap<PMDNode, PMDRigidBody[]>();
    Map<PMDNode, SixDofJoint[]> constraintMap = new HashMap<PMDNode, SixDofJoint[]>();
    float accuracy = 0.008333334f;
    float[] buf = new float[3];
    Transform t = new Transform();
    Quaternion rot2 = new Quaternion();
    Quat4f rot = new Quat4f();
    Transform t1 = new Transform();
    Transform t2 = new Transform();
    Vector3f v1 = new Vector3f();
    Vector3f v2 = new Vector3f();

    public PMDPhysicsWorld() {
        float dist = 400.0f;
        this.physicsSpace = new PhysicsSpace(new Vector3f(-dist, -dist, -dist), new Vector3f(dist, dist, dist), PhysicsSpace.BroadphaseType.AXIS_SWEEP_3);
        this.physicsSpace.setGravity(new Vector3f(0.0f, -9.8f, 0.0f));
        this.physicsSpace.setAccuracy(this.accuracy);
    }

    public void addPMDNode(PMDNode pmdNode) {
        Skeleton skeleton = pmdNode.getSkeleton();
        skeleton.updateWorldVectors();
        PMDModel pmdModel = pmdNode.getPmdModel();
        PMDRigidBody[] rigidBodyArray = new PMDRigidBody[pmdModel.getRigidBodyList().getRigidBodyArray().length];
        this.rigidBodyMap.put(pmdNode, rigidBodyArray);
        for (int i = 0; i < pmdModel.getRigidBodyList().getRigidBodyArray().length; ++i) {
            PMDRigidBody rb;
            projectkyoto.mmd.file.PMDRigidBody fileRigidBody = pmdModel.getRigidBodyList().getRigidBodyArray()[i];
            Bone bone = null;
            if (fileRigidBody.getRelBoneIndex() != 65535) {
                bone = skeleton.getBone(fileRigidBody.getRelBoneIndex());
            }
            rigidBodyArray[i] = rb = this.createRigidBody(pmdNode, fileRigidBody, bone);
            rb.setCollisionGroup(1 << fileRigidBody.getRigidBodyGroupIndex());
            rb.setCollideWithGroups(fileRigidBody.getRigidBodyGroupTarget());
            this.physicsSpace.addCollisionObject((PhysicsCollisionObject)rb);
        }
        SixDofJoint[] constArray = new SixDofJoint[pmdModel.getJointList().getJointCount()];
        this.constraintMap.put(pmdNode, constArray);
        for (int i = 0; i < constArray.length; ++i) {
            SixDofJoint constraint;
            constArray[i] = constraint = this.createConstraint(pmdNode, rigidBodyArray, pmdModel.getJointList().getJointArray()[i]);
            this.physicsSpace.add((Object)constraint);
        }
    }

    public void removePMDNode(PMDNode pmdNode) {
        SixDofJoint[] constArray;
        PMDRigidBody[] rigidBodyArray = this.rigidBodyMap.remove(pmdNode);
        if (rigidBodyArray != null) {
            for (PMDRigidBody rb : rigidBodyArray) {
                this.physicsSpace.remove((Object)rb);
            }
        }
        if ((constArray = this.constraintMap.remove(pmdNode)) != null) {
            for (SixDofJoint joint : constArray) {
                this.physicsSpace.remove((Object)joint);
            }
        }
    }

    PMDRigidBody createRigidBody(PMDNode pmdNode, projectkyoto.mmd.file.PMDRigidBody fileRigidBody, Bone bone) {
        float mass;
        SphereCollisionShape cs;
        javax.vecmath.Vector3f localInertia = new javax.vecmath.Vector3f();
        boolean kinematic = false;
        Matrix4f trans = new Matrix4f();
        Matrix4f trans2 = new Matrix4f();
        Vector3f v = new Vector3f(fileRigidBody.getPos().x, fileRigidBody.getPos().y, fileRigidBody.getPos().z);
        trans.loadIdentity();
        Quaternion q = new Quaternion(this.buf);
        Matrix3f rotMatrix = new Matrix3f();
        this.convPMDEuler(rotMatrix, fileRigidBody.getRot().x, fileRigidBody.getRot().y, fileRigidBody.getRot().z);
        Matrix4f m = new Matrix4f();
        m.loadIdentity();
        m.setTransform(v, new Vector3f(1.0f, 1.0f, 1.0f), rotMatrix);
        q = m.toRotationQuat();
        v = m.toTranslationVector();
        trans2.loadIdentity();
        trans2.setRotationQuaternion(q);
        trans2.setTranslation(v);
        Matrix4f m2 = new Matrix4f();
        m2.loadIdentity();
        if (bone != null) {
            m2.setTransform(bone.getModelSpacePosition(), bone.getModelSpaceScale(), bone.getModelSpaceRotation().toRotationMatrix());
        } else {
            Bone centerBone = pmdNode.getSkeleton().getBone("\u30bb\u30f3\u30bf\u30fc");
            m2.setTransform(centerBone.getModelSpacePosition(), centerBone.getModelSpaceScale(), centerBone.getModelSpaceRotation().toRotationMatrix());
        }
        m2.mult(m, m);
        q = m.toRotationQuat();
        v = m.toTranslationVector();
        trans.loadIdentity();
        trans.setRotationQuaternion(q);
        trans.setTranslation(v);
        float margin = 0.0f;
        switch (fileRigidBody.getShapeType()) {
            case 0: {
                cs = new SphereCollisionShape(fileRigidBody.getShapeW() - margin);
                break;
            }
            case 1: {
                cs = new BoxCollisionShape(new Vector3f(fileRigidBody.getShapeW() - margin, fileRigidBody.getShapeH() - margin, fileRigidBody.getShapeD() - margin));
                break;
            }
            case 2: {
                cs = new CapsuleCollisionShape(fileRigidBody.getShapeW() - margin, fileRigidBody.getShapeH() - margin);
                break;
            }
            default: {
                throw new PMDException("Invalid getShapeType:" + fileRigidBody.getRigidBodyName() + " " + fileRigidBody.getShapeType());
            }
        }
        cs.setMargin(0.01f);
        if (fileRigidBody.getRigidBodyType() != 0) {
            mass = fileRigidBody.getWeight();
            kinematic = false;
        } else {
            mass = 0.0f;
            kinematic = true;
        }
        if (mass != 0.0f) {
            // empty if block
        }
        PMDRigidBody rb = new PMDRigidBody(pmdNode, bone, fileRigidBody.getRigidBodyType(), trans2.toTranslationVector(), trans2.toRotationQuat(), (CollisionShape)cs, mass);
        rb.updateFromBoneMatrix();
        rb.setMass(mass);
        rb.setDamping(fileRigidBody.getPosDim(), fileRigidBody.getRotDim());
        rb.setRestitution(fileRigidBody.getRecoil());
        rb.setFriction(fileRigidBody.getFriction());
        if (kinematic) {
            rb.setKinematic(true);
        } else {
            rb.setKinematic(false);
        }
        return rb;
    }

    void _convPMDEuler(Matrix3f out, float x, float y, float z) {
        Quaternion qx = new Quaternion();
        Quaternion qy = new Quaternion();
        Quaternion qz = new Quaternion();
        qx.fromAngles(x, 0.0f, 0.0f);
        qy.fromAngles(0.0f, y, 0.0f);
        qz.fromAngles(0.0f, 0.0f, z);
        qz.multLocal(qy);
        qz.multLocal(qx);
        qz.toRotationMatrix(out);
    }

    void convPMDEuler(Matrix3f out, float x, float y, float z) {
        Quaternion qx = new Quaternion();
        Quaternion qy = new Quaternion();
        Quaternion qz = new Quaternion();
        qx.fromAngles(x, 0.0f, 0.0f);
        qy.fromAngles(0.0f, y, 0.0f);
        qz.fromAngles(0.0f, 0.0f, z);
        qy.multLocal(qz);
        qy.multLocal(qx);
        qy.toRotationMatrix(out);
    }

    Vector3f convVec(javax.vecmath.Vector3f v) {
        return new Vector3f(v.x, v.y, v.z);
    }

    SixDofJoint createConstraint(PMDNode pmdNode, PMDRigidBody[] rigidBodyArray, PMDJoint pmdJoint) {
        PMDRigidBody rba = rigidBodyArray[pmdJoint.getRigidBodyA()];
        PMDRigidBody rbb = rigidBodyArray[pmdJoint.getRigidBodyB()];
        Matrix4f trans = new Matrix4f();
        trans.loadIdentity();
        Quaternion q = new Quaternion();
        Quaternion q3 = new Quaternion();
        Matrix3f m2 = new Matrix3f();
        m2.loadIdentity();
        this.convPMDEuler(m2, pmdJoint.getJointRot().x, pmdJoint.getJointRot().y, pmdJoint.getJointRot().z);
        Matrix4f m = new Matrix4f();
        m.loadIdentity();
        Vector3f v = new Vector3f(pmdJoint.getJointPos().x, pmdJoint.getJointPos().y, pmdJoint.getJointPos().z);
        Bone centerBone = pmdNode.getSkeleton().getBone("\u30bb\u30f3\u30bf\u30fc");
        m.setTransform(v, centerBone.getModelSpaceScale(), m2);
        q = m.toRotationQuat();
        trans.setRotationQuaternion(q);
        trans.setTranslation(pmdJoint.getJointPos().x, pmdJoint.getJointPos().y, pmdJoint.getJointPos().z);
        Matrix4f transA = new Matrix4f();
        transA.loadIdentity();
        transA.setRotationQuaternion(rba.getPhysicsRotation());
        transA.setTranslation(rba.getPhysicsLocation());
        transA.invertLocal();
        transA.multLocal(trans);
        Matrix4f transB = new Matrix4f();
        transB.loadIdentity();
        transB.setTranslation(rbb.getPhysicsLocation());
        transB.setRotationQuaternion(rbb.getPhysicsRotation());
        transB.invertLocal();
        transB.multLocal(trans);
        Matrix4f transJ = new Matrix4f();
        transJ.loadIdentity();
        transJ.setTranslation(pmdJoint.getJointPos().x, pmdJoint.getJointPos().y, pmdJoint.getJointPos().z);
        this.convPMDEuler(m2, pmdJoint.getJointRot().x, pmdJoint.getJointRot().y, pmdJoint.getJointRot().z);
        q.fromRotationMatrix(m2);
        transJ.setRotationQuaternion(q);
        Matrix4f centerA = new Matrix4f();
        centerA.setRotationQuaternion(rba.getPhysicsRotation());
        centerA.setTranslation(rba.getPhysicsLocation());
        Matrix4f invCenterA = centerA.invert();
        Matrix4f centerB = new Matrix4f();
        centerB.setRotationQuaternion(rbb.getPhysicsRotation());
        centerB.setTranslation(rbb.getPhysicsLocation());
        Matrix4f invCenterB = centerB.invert();
        Matrix4f frameInA = invCenterA.mult(transJ);
        Matrix4f frameInB = invCenterB.mult(transJ);
        SixDofSpringJoint constraint = new SixDofSpringJoint((PhysicsRigidBody)rba, (PhysicsRigidBody)rbb, frameInA.toTranslationVector(), frameInB.toTranslationVector(), frameInA.toRotationMatrix(), frameInB.toRotationMatrix(), true);
        constraint.setLinearLowerLimit(this.convVec(pmdJoint.getConstPos1()));
        constraint.setLinearUpperLimit(this.convVec(pmdJoint.getConstPos2()));
        Vector3f constRot1 = this.convVec(pmdJoint.getConstRot1());
        if (constRot1.getY() <= (float)Math.PI * -2) {
            constRot1.setY(-1.5393804f);
            System.out.println("constRot1 y must > -90");
        }
        constraint.setAngularLowerLimit(constRot1);
        Vector3f constRot2 = this.convVec(pmdJoint.getConstRot2());
        if (constRot2.getY() >= (float)Math.PI * 2) {
            constRot2.setY(1.5393804f);
            System.out.println("constRot2 y must < 90");
        }
        constraint.setAngularUpperLimit(constRot2);
        constraint.setEquilibriumPoint();
        for (int i = 0; i < 6; ++i) {
            float f = pmdJoint.getStiffness()[i];
            if (i < 3 && f == 0.0f) continue;
            constraint.enableSpring(i, true);
            constraint.setStiffness(i, f);
        }
        return constraint;
    }

    public void updateKinematicPos() {
        for (PMDRigidBody[] rbarray : this.rigidBodyMap.values()) {
            for (int i = 0; i < rbarray.length; ++i) {
                PMDRigidBody rb = rbarray[i];
                PMDNode pmdNode = rb.getPmdNode();
                if (!rb.isKinematic()) continue;
                rb.updateFromBoneMatrix();
            }
        }
    }

    void stepSimulation(float timeStep) {
        this.physicsSpace.update(timeStep, 10);
    }

    public void applyResultToBone() {
        for (PMDRigidBody[] rbarray : this.rigidBodyMap.values()) {
            for (int i = 0; i < rbarray.length; ++i) {
                PMDRigidBody rb = rbarray[i];
                if (rb.getBone() == null || rb.isKinematic()) continue;
                PMDNode pmdNode = rb.getPmdNode();
                rb.updateToBoneMatrix();
            }
        }
    }

    public void resetRigidBodyPos() {
        for (PMDRigidBody[] rbarray : this.rigidBodyMap.values()) {
            for (int i = 0; i < rbarray.length; ++i) {
                PMDRigidBody rb = rbarray[i];
                PMDNode pmdNode = rb.getPmdNode();
                Node rigidBodyNode = pmdNode.getRigidBodyNode();
                rb.updateFromBoneMatrix();
                rb.setLinearVelocity(Vector3f.ZERO);
                rb.setAngularVelocity(Vector3f.ZERO);
            }
        }
    }

    public void updateRigidBodyPos() {
        for (PMDRigidBody[] rbarray : this.rigidBodyMap.values()) {
            for (int i = 0; i < rbarray.length; ++i) {
                PMDRigidBody rb = rbarray[i];
                PMDNode pmdNode = rb.getPmdNode();
                Node rigidBodyNode = pmdNode.getRigidBodyNode();
                if (rigidBodyNode == null) continue;
                Spatial spaital = rigidBodyNode.getChild(i);
                spaital.setLocalRotation(rb.getPhysicsRotation());
                spaital.setLocalTranslation(rb.getPhysicsLocation());
            }
        }
    }

    void updateJointPosition(PMDNode pmdNode) {
    }

    void updateJointPosition(SixDofJoint constraint, Line line) {
    }

    public float getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(float accuracy) {
        this.accuracy = accuracy;
        this.physicsSpace.setAccuracy(accuracy);
    }

    public PhysicsSpace getPhysicsSpace() {
        return this.physicsSpace;
    }
}

