/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file;

import java.io.IOException;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4f;
import projectkyoto.mmd.file.DataInputStreamLittleEndian;

public class VMDMotion {
    private String boneName;
    private int frameNo;
    private Point3f location;
    private Quat4f rotation;
    private byte[] interpolation = new byte[64];

    public VMDMotion(DataInputStreamLittleEndian is) throws IOException {
        this.boneName = is.readString(15);
        this.frameNo = is.readInt();
        this.location = new Point3f();
        this.location.x = is.readFloat();
        this.location.y = is.readFloat();
        this.location.z = -is.readFloat();
        this.rotation = new Quat4f(is.readFloat(), is.readFloat(), -is.readFloat(), -is.readFloat());
        is.read(this.interpolation);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{boneName = " + this.boneName + " frameNo = " + this.frameNo + " location = " + this.location + " rotation = " + this.rotation + " interpolation = {");
        for (int i = 0; i < 64; ++i) {
            sb.append(this.interpolation[i]).append(',');
        }
        sb.append("}}\n");
        return sb.toString();
    }

    public String getBoneName() {
        return this.boneName;
    }

    public void setBoneName(String boneName) {
        this.boneName = boneName;
    }

    public int getFrameNo() {
        return this.frameNo;
    }

    public void setFlameNo(int frameNo) {
        this.frameNo = frameNo;
    }

    public byte[] getInterpolation() {
        return this.interpolation;
    }

    public void setInterpolation(byte[] interpolation) {
        this.interpolation = interpolation;
    }

    public Point3f getLocation() {
        return this.location;
    }

    public void setLocation(Point3f location) {
        this.location = location;
    }

    public Quat4f getRotation() {
        return this.rotation;
    }

    public void setRotation(Quat4f rotation) {
        this.rotation = rotation;
    }
}

