/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.objects.VehicleWheel;
import com.jme3.bullet.objects.infos.VehicleTuning;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.Arrow;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PhysicsVehicle
extends PhysicsRigidBody {
    protected long vehicleId = 0L;
    protected long rayCasterId = 0L;
    protected VehicleTuning tuning;
    protected ArrayList<VehicleWheel> wheels = new ArrayList();
    protected PhysicsSpace physicsSpace;

    public PhysicsVehicle() {
    }

    public PhysicsVehicle(CollisionShape collisionShape) {
        super(collisionShape);
    }

    public PhysicsVehicle(CollisionShape collisionShape, float f) {
        super(collisionShape, f);
    }

    public void updateWheels() {
        if (this.vehicleId != 0L) {
            for (int i = 0; i < this.wheels.size(); ++i) {
                this.updateWheelTransform(this.vehicleId, i, true);
                this.wheels.get(i).updatePhysicsState();
            }
        }
    }

    private native void updateWheelTransform(long var1, int var3, boolean var4);

    public void applyWheelTransforms() {
        if (this.wheels != null) {
            for (int i = 0; i < this.wheels.size(); ++i) {
                this.wheels.get(i).applyWheelTransform();
            }
        }
    }

    @Override
    protected void postRebuild() {
        super.postRebuild();
        if (this.tuning == null) {
            this.tuning = new VehicleTuning();
        }
        this.motionState.setVehicle(this);
    }

    public void createVehicle(PhysicsSpace physicsSpace) {
        this.physicsSpace = physicsSpace;
        if (physicsSpace == null) {
            return;
        }
        if (physicsSpace.getSpaceId() == 0L) {
            throw new IllegalStateException("Physics space is not initialized!");
        }
        if (this.rayCasterId != 0L) {
            physicsSpace.removeCollisionObject(this);
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Clearing RayCaster {0}", Long.toHexString(this.rayCasterId));
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Clearing Vehicle {0}", Long.toHexString(this.vehicleId));
            this.finalizeNative(this.rayCasterId, this.vehicleId);
        }
        this.rayCasterId = this.createVehicleRaycaster(this.objectId, physicsSpace.getSpaceId());
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Created RayCaster {0}", Long.toHexString(this.rayCasterId));
        this.vehicleId = this.createRaycastVehicle(this.objectId, this.rayCasterId);
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Created Vehicle {0}", Long.toHexString(this.vehicleId));
        this.setCoordinateSystem(this.vehicleId, 0, 1, 2);
        for (VehicleWheel vehicleWheel : this.wheels) {
            vehicleWheel.setWheelId(this.addWheel(this.vehicleId, vehicleWheel.getLocation(), vehicleWheel.getDirection(), vehicleWheel.getAxle(), vehicleWheel.getRestLength(), vehicleWheel.getRadius(), this.tuning, vehicleWheel.isFrontWheel()));
        }
    }

    private native long createVehicleRaycaster(long var1, long var3);

    private native long createRaycastVehicle(long var1, long var3);

    private native void setCoordinateSystem(long var1, int var3, int var4, int var5);

    private native long addWheel(long var1, Vector3f var3, Vector3f var4, Vector3f var5, float var6, float var7, VehicleTuning var8, boolean var9);

    public VehicleWheel addWheel(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, float f, float f2, boolean bl) {
        return this.addWheel(null, vector3f, vector3f2, vector3f3, f, f2, bl);
    }

    public VehicleWheel addWheel(Spatial spatial, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, float f, float f2, boolean bl) {
        VehicleWheel vehicleWheel = null;
        vehicleWheel = spatial == null ? new VehicleWheel(vector3f, vector3f2, vector3f3, f, f2, bl) : new VehicleWheel(spatial, vector3f, vector3f2, vector3f3, f, f2, bl);
        if (this.vehicleId != 0L) {
            vehicleWheel.setWheelId(this.addWheel(this.vehicleId, vehicleWheel.getLocation(), vehicleWheel.getDirection(), vehicleWheel.getAxle(), vehicleWheel.getRestLength(), vehicleWheel.getRadius(), this.tuning, vehicleWheel.isFrontWheel()));
        }
        vehicleWheel.setFrictionSlip(this.tuning.frictionSlip);
        vehicleWheel.setMaxSuspensionTravelCm(this.tuning.maxSuspensionTravelCm);
        vehicleWheel.setSuspensionStiffness(this.tuning.suspensionStiffness);
        vehicleWheel.setWheelsDampingCompression(this.tuning.suspensionCompression);
        vehicleWheel.setWheelsDampingRelaxation(this.tuning.suspensionDamping);
        vehicleWheel.setMaxSuspensionForce(this.tuning.maxSuspensionForce);
        this.wheels.add(vehicleWheel);
        if (this.debugShape != null) {
            this.updateDebugShape();
        }
        return vehicleWheel;
    }

    public void removeWheel(int n) {
        this.wheels.remove(n);
        this.rebuildRigidBody();
    }

    public VehicleWheel getWheel(int n) {
        return this.wheels.get(n);
    }

    public int getNumWheels() {
        return this.wheels.size();
    }

    public float getFrictionSlip() {
        return this.tuning.frictionSlip;
    }

    public void setFrictionSlip(float f) {
        this.tuning.frictionSlip = f;
    }

    public void setFrictionSlip(int n, float f) {
        this.wheels.get(n).setFrictionSlip(f);
    }

    public void setRollInfluence(int n, float f) {
        this.wheels.get(n).setRollInfluence(f);
    }

    public float getMaxSuspensionTravelCm() {
        return this.tuning.maxSuspensionTravelCm;
    }

    public void setMaxSuspensionTravelCm(float f) {
        this.tuning.maxSuspensionTravelCm = f;
    }

    public void setMaxSuspensionTravelCm(int n, float f) {
        this.wheels.get(n).setMaxSuspensionTravelCm(f);
    }

    public float getMaxSuspensionForce() {
        return this.tuning.maxSuspensionForce;
    }

    public void setMaxSuspensionForce(float f) {
        this.tuning.maxSuspensionForce = f;
    }

    public void setMaxSuspensionForce(int n, float f) {
        this.wheels.get(n).setMaxSuspensionForce(f);
    }

    public float getSuspensionCompression() {
        return this.tuning.suspensionCompression;
    }

    public void setSuspensionCompression(float f) {
        this.tuning.suspensionCompression = f;
    }

    public void setSuspensionCompression(int n, float f) {
        this.wheels.get(n).setWheelsDampingCompression(f);
    }

    public float getSuspensionDamping() {
        return this.tuning.suspensionDamping;
    }

    public void setSuspensionDamping(float f) {
        this.tuning.suspensionDamping = f;
    }

    public void setSuspensionDamping(int n, float f) {
        this.wheels.get(n).setWheelsDampingRelaxation(f);
    }

    public float getSuspensionStiffness() {
        return this.tuning.suspensionStiffness;
    }

    public void setSuspensionStiffness(float f) {
        this.tuning.suspensionStiffness = f;
    }

    public void setSuspensionStiffness(int n, float f) {
        this.wheels.get(n).setSuspensionStiffness(f);
    }

    public void resetSuspension() {
        this.resetSuspension(this.vehicleId);
    }

    private native void resetSuspension(long var1);

    public void accelerate(float f) {
        for (int i = 0; i < this.wheels.size(); ++i) {
            this.accelerate(i, f);
        }
    }

    public void accelerate(int n, float f) {
        this.applyEngineForce(this.vehicleId, n, f);
    }

    private native void applyEngineForce(long var1, int var3, float var4);

    public void steer(float f) {
        for (int i = 0; i < this.wheels.size(); ++i) {
            if (!this.getWheel(i).isFrontWheel()) continue;
            this.steer(i, f);
        }
    }

    public void steer(int n, float f) {
        this.steer(this.vehicleId, n, f);
    }

    private native void steer(long var1, int var3, float var4);

    public void brake(float f) {
        for (int i = 0; i < this.wheels.size(); ++i) {
            this.brake(i, f);
        }
    }

    public void brake(int n, float f) {
        this.brake(this.vehicleId, n, f);
    }

    private native void brake(long var1, int var3, float var4);

    public float getCurrentVehicleSpeedKmHour() {
        return this.getCurrentVehicleSpeedKmHour(this.vehicleId);
    }

    private native float getCurrentVehicleSpeedKmHour(long var1);

    public Vector3f getForwardVector(Vector3f vector3f) {
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        this.getForwardVector(this.vehicleId, vector3f);
        return vector3f;
    }

    private native void getForwardVector(long var1, Vector3f var3);

    public long getVehicleId() {
        return this.vehicleId;
    }

    @Override
    protected Spatial getDebugShape() {
        Spatial spatial = super.getDebugShape();
        Node node = null;
        if (spatial instanceof Node) {
            node = (Node)spatial;
        } else {
            node = new Node("DebugShapeNode");
            node.attachChild(spatial);
        }
        int n = 0;
        for (VehicleWheel vehicleWheel : this.wheels) {
            Vector3f vector3f = vehicleWheel.getLocation().clone();
            Vector3f vector3f2 = vehicleWheel.getDirection().clone();
            Vector3f vector3f3 = vehicleWheel.getAxle().clone();
            float f = vehicleWheel.getRestLength();
            float f2 = vehicleWheel.getRadius();
            Arrow arrow = new Arrow(vector3f);
            Arrow arrow2 = new Arrow(vector3f3.normalizeLocal().multLocal(0.3f));
            Arrow arrow3 = new Arrow(vector3f2.normalizeLocal().multLocal(f2));
            Arrow arrow4 = new Arrow(vector3f2.normalizeLocal().multLocal(f));
            Geometry geometry = new Geometry("WheelLocationDebugShape" + n, (Mesh)arrow);
            Geometry geometry2 = new Geometry("WheelDirectionDebugShape" + n, (Mesh)arrow4);
            Geometry geometry3 = new Geometry("WheelAxleDebugShape" + n, (Mesh)arrow2);
            Geometry geometry4 = new Geometry("WheelRadiusDebugShape" + n, (Mesh)arrow3);
            geometry2.setLocalTranslation(vector3f);
            geometry3.setLocalTranslation(vector3f.add(vector3f2));
            geometry4.setLocalTranslation(vector3f.add(vector3f2));
            geometry.setMaterial(this.debugMaterialGreen);
            geometry2.setMaterial(this.debugMaterialGreen);
            geometry3.setMaterial(this.debugMaterialGreen);
            geometry4.setMaterial(this.debugMaterialGreen);
            node.attachChild((Spatial)geometry);
            node.attachChild((Spatial)geometry2);
            node.attachChild((Spatial)geometry3);
            node.attachChild((Spatial)geometry4);
            ++n;
        }
        return node;
    }

    @Override
    public void read(JmeImporter jmeImporter) throws IOException {
        InputCapsule inputCapsule = jmeImporter.getCapsule((Savable)this);
        this.tuning = new VehicleTuning();
        this.tuning.frictionSlip = inputCapsule.readFloat("frictionSlip", 10.5f);
        this.tuning.maxSuspensionTravelCm = inputCapsule.readFloat("maxSuspensionTravelCm", 500.0f);
        this.tuning.maxSuspensionForce = inputCapsule.readFloat("maxSuspensionForce", 6000.0f);
        this.tuning.suspensionCompression = inputCapsule.readFloat("suspensionCompression", 0.83f);
        this.tuning.suspensionDamping = inputCapsule.readFloat("suspensionDamping", 0.88f);
        this.tuning.suspensionStiffness = inputCapsule.readFloat("suspensionStiffness", 5.88f);
        this.wheels = inputCapsule.readSavableArrayList("wheelsList", new ArrayList());
        this.motionState.setVehicle(this);
        super.read(jmeImporter);
    }

    @Override
    public void write(JmeExporter jmeExporter) throws IOException {
        OutputCapsule outputCapsule = jmeExporter.getCapsule((Savable)this);
        outputCapsule.write(this.tuning.frictionSlip, "frictionSlip", 10.5f);
        outputCapsule.write(this.tuning.maxSuspensionTravelCm, "maxSuspensionTravelCm", 500.0f);
        outputCapsule.write(this.tuning.maxSuspensionForce, "maxSuspensionForce", 6000.0f);
        outputCapsule.write(this.tuning.suspensionCompression, "suspensionCompression", 0.83f);
        outputCapsule.write(this.tuning.suspensionDamping, "suspensionDamping", 0.88f);
        outputCapsule.write(this.tuning.suspensionStiffness, "suspensionStiffness", 5.88f);
        outputCapsule.writeSavableArrayList(this.wheels, "wheelsList", new ArrayList());
        super.write(jmeExporter);
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Finalizing RayCaster {0}", Long.toHexString(this.rayCasterId));
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Finalizing Vehicle {0}", Long.toHexString(this.vehicleId));
        this.finalizeNative(this.rayCasterId, this.vehicleId);
    }

    private native void finalizeNative(long var1, long var3);
}

