/*
 * Decompiled with CFR 0.152.
 */
package jme3test.app;

import com.jme3.renderer.IDList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class TestIDList {
    static IDList list = new IDList();
    static int boundSlot = 0;
    static Object[] slots = new Object[16];
    static boolean[] enabledSlots = new boolean[16];

    static void enable(int slot) {
        System.out.println("Enabled SLOT[" + slot + "]");
        if (enabledSlots[slot]) {
            System.err.println("FAIL! Extra state change");
        }
        TestIDList.enabledSlots[slot] = true;
    }

    static void disable(int slot) {
        System.out.println("Disabled SLOT[" + slot + "]");
        if (!enabledSlots[slot]) {
            System.err.println("FAIL! Extra state change");
        }
        TestIDList.enabledSlots[slot] = false;
    }

    static void setSlot(int slot, Object val) {
        if (!list.moveToNew(slot)) {
            TestIDList.enable(slot);
        }
        if (slots[slot] != val) {
            System.out.println("SLOT[" + slot + "] = " + val.hashCode());
            TestIDList.slots[slot] = val;
        }
    }

    static void checkSlots(StateCol state) {
        for (int i = 0; i < 16; ++i) {
            Object val;
            if (slots[i] != null && !enabledSlots[i]) {
                System.err.println("FAIL! SLOT[" + i + "] assigned, but disabled");
            }
            if (slots[i] == null && enabledSlots[i]) {
                System.err.println("FAIL! SLOT[" + i + "] enabled, but not assigned");
            }
            if ((val = state.objs.get(i)) != null) {
                if (slots[i] != val) {
                    System.err.println("FAIL! SLOT[" + i + "] does not contain correct value");
                }
                if (enabledSlots[i]) continue;
                System.err.println("FAIL! SLOT[" + i + "] is not enabled");
                continue;
            }
            if (slots[i] != null) {
                System.err.println("FAIL! SLOT[" + i + "] is not set");
            }
            if (!enabledSlots[i]) continue;
            System.err.println("FAIL! SLOT[" + i + "] is enabled");
        }
    }

    static void clearSlots() {
        for (int i = 0; i < TestIDList.list.oldLen; ++i) {
            int slot = TestIDList.list.oldList[i];
            TestIDList.disable(slot);
            TestIDList.slots[slot] = null;
        }
        list.copyNewToOld();
    }

    static void setState(StateCol state) {
        state.print();
        for (Map.Entry<Integer, Object> entry : state.objs.entrySet()) {
            TestIDList.setSlot(entry.getKey(), entry.getValue());
        }
        TestIDList.clearSlots();
        TestIDList.checkSlots(state);
    }

    public static void main(String[] args) {
        int i;
        StateCol[] states = new StateCol[20];
        for (i = 0; i < states.length; ++i) {
            states[i] = new StateCol();
        }
        for (i = 0; i < states.length; ++i) {
            TestIDList.setState(states[i]);
        }
    }

    static class StateCol {
        static Random rand = new Random();
        Map<Integer, Object> objs = new HashMap<Integer, Object>();

        public StateCol() {
            ArrayList<Integer> freeIds = new ArrayList<Integer>();
            for (int i = 0; i < 16; ++i) {
                freeIds.add(i);
            }
            int numStates = rand.nextInt(6) + 1;
            for (int i = 0; i < numStates; ++i) {
                int idx = rand.nextInt(freeIds.size());
                int id = (Integer)freeIds.remove(idx);
                this.objs.put(id, new Object());
            }
        }

        public void print() {
            System.out.println("-----------------");
            Set<Integer> keys = this.objs.keySet();
            Object[] keysArr = keys.toArray(new Integer[0]);
            Arrays.sort(keysArr);
            for (int i = 0; i < keysArr.length; ++i) {
                System.out.println(keysArr[i] + " => " + this.objs.get(keysArr[i]).hashCode());
            }
        }
    }
}

