/*
 * Decompiled with CFR 0.152.
 */
package jme3test.app.state;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.niftygui.NiftyJmeDisplay;
import com.jme3.post.SceneProcessor;
import com.jme3.scene.Spatial;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import jme3test.app.state.RootNodeState;

public class TestAppStates
extends Application {
    public static void main(String[] args) {
        TestAppStates app = new TestAppStates();
        app.start();
    }

    public void start(JmeContext.Type contextType) {
        AppSettings settings = new AppSettings(true);
        settings.setResolution(1024, 768);
        this.setSettings(settings);
        super.start(contextType);
    }

    public void initialize() {
        super.initialize();
        System.out.println("Initialize");
        RootNodeState state = new RootNodeState();
        this.viewPort.attachScene((Spatial)state.getRootNode());
        this.stateManager.attach((AppState)state);
        Spatial model = this.assetManager.loadModel("Models/Teapot/Teapot.obj");
        model.scale(3.0f);
        model.setMaterial(this.assetManager.loadMaterial("Interface/Logo/Logo.j3m"));
        state.getRootNode().attachChild(model);
        NiftyJmeDisplay niftyDisplay = new NiftyJmeDisplay(this.assetManager, this.inputManager, this.audioRenderer, this.guiViewPort);
        niftyDisplay.getNifty().fromXml("Interface/Nifty/HelloJme.xml", "start");
        this.guiViewPort.addProcessor((SceneProcessor)niftyDisplay);
    }

    public void update() {
        super.update();
        float tpf = this.timer.getTimePerFrame();
        this.stateManager.update(tpf);
        this.stateManager.render(this.renderManager);
        this.renderManager.render(tpf);
    }

    public void destroy() {
        super.destroy();
        System.out.println("Destroy");
    }
}

