/*
 * Decompiled with CFR 0.152.
 */
package jme3test.audio;

import com.jme3.app.SimpleApplication;
import com.jme3.audio.AudioNode;
import com.jme3.audio.Environment;
import com.jme3.math.Vector3f;
import org.lwjgl.openal.AL10;

public class TestDoppler
extends SimpleApplication {
    private AudioNode ufo;
    private float x = 20.0f;
    private float z = 0.0f;
    private float rate = -0.05f;
    private float xDist = 20.0f;
    private float zDist = 5.0f;
    private float angle = (float)Math.PI * 2;

    public static void main(String[] args) {
        TestDoppler test = new TestDoppler();
        test.start();
    }

    public void simpleInitApp() {
        this.audioRenderer.setEnvironment(Environment.Dungeon);
        AL10.alDistanceModel((int)53253);
        this.ufo = new AudioNode(this.assetManager, "Sound/Effects/Beep.ogg", false);
        this.ufo.setPositional(true);
        this.ufo.setLooping(true);
        this.ufo.setReverbEnabled(true);
        this.ufo.setRefDistance(1.0E8f);
        this.ufo.setMaxDistance(1.0E8f);
        this.ufo.play();
    }

    public void simpleUpdate(float tpf) {
        float dx = (float)Math.sin(this.angle) * this.xDist;
        float dz = (float)(-Math.cos(this.angle) * (double)this.zDist);
        this.x += dx * tpf * 0.05f;
        this.z += dz * tpf * 0.05f;
        this.angle += tpf * this.rate;
        if (this.angle > (float)Math.PI * 2) {
            this.angle = (float)Math.PI * 2;
            this.rate = -this.rate;
        } else if (this.angle < 0.0f) {
            this.angle = 0.0f;
            this.rate = -this.rate;
        }
        this.ufo.setVelocity(new Vector3f(dx, 0.0f, dz));
        this.ufo.setLocalTranslation(this.x, 0.0f, this.z);
        this.ufo.updateGeometricState();
        System.out.println("LOC: " + (int)this.x + ", " + (int)this.z + ", VEL: " + (int)dx + ", " + (int)dz);
    }
}

