/*
 * Decompiled with CFR 0.152.
 */
package jme3test.audio;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.audio.AudioData;
import com.jme3.audio.AudioKey;
import com.jme3.audio.AudioNode;
import com.jme3.audio.AudioRenderer;
import com.jme3.audio.Listener;
import com.jme3.audio.plugins.OGGLoader;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeSystem;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TestMusicPlayer
extends JFrame {
    private AudioRenderer ar;
    private AudioData musicData;
    private AudioNode musicSource;
    private float musicLength = 0.0f;
    private float curTime = 0.0f;
    private Listener listener = new Listener();
    private JButton btnFF;
    private JButton btnOpen;
    private JButton btnPlay;
    private JButton btnRewind;
    private JButton btnStop;
    private JLabel lblTime;
    private JPanel pnlBar;
    private JPanel pnlButtons;
    private JSlider sldBar;
    private JSlider sldVolume;

    public TestMusicPlayer() {
        this.initComponents();
        this.setLocationRelativeTo(null);
        this.initAudioPlayer();
    }

    private void initAudioPlayer() {
        AppSettings settings = new AppSettings(true);
        settings.setRenderer(null);
        settings.setAudioRenderer("LWJGL");
        this.ar = JmeSystem.newAudioRenderer((AppSettings)settings);
        this.ar.initialize();
        this.ar.setListener(this.listener);
    }

    private void initComponents() {
        this.pnlButtons = new JPanel();
        this.sldVolume = new JSlider();
        this.btnRewind = new JButton();
        this.btnStop = new JButton();
        this.btnPlay = new JButton();
        this.btnFF = new JButton();
        this.btnOpen = new JButton();
        this.pnlBar = new JPanel();
        this.lblTime = new JLabel();
        this.sldBar = new JSlider();
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                TestMusicPlayer.this.formWindowClosing(evt);
            }
        });
        this.pnlButtons.setLayout(new BoxLayout(this.pnlButtons, 2));
        this.sldVolume.setMajorTickSpacing(20);
        this.sldVolume.setOrientation(1);
        this.sldVolume.setPaintTicks(true);
        this.sldVolume.setValue(100);
        this.sldVolume.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                TestMusicPlayer.this.sldVolumeStateChanged(evt);
            }
        });
        this.pnlButtons.add(this.sldVolume);
        this.btnRewind.setText("<<");
        this.pnlButtons.add(this.btnRewind);
        this.btnStop.setText("[  ]");
        this.btnStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TestMusicPlayer.this.btnStopActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.btnStop);
        this.btnPlay.setText("II / >");
        this.btnPlay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TestMusicPlayer.this.btnPlayActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.btnPlay);
        this.btnFF.setText(">>");
        this.btnFF.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TestMusicPlayer.this.btnFFActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.btnFF);
        this.btnOpen.setText("Open ...");
        this.btnOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TestMusicPlayer.this.btnOpenActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.btnOpen);
        this.getContentPane().add((Component)this.pnlButtons, "Center");
        this.pnlBar.setLayout(new BoxLayout(this.pnlBar, 2));
        this.lblTime.setText("0:00-0:00");
        this.lblTime.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.pnlBar.add(this.lblTime);
        this.sldBar.setValue(0);
        this.sldBar.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                TestMusicPlayer.this.sldBarStateChanged(evt);
            }
        });
        this.pnlBar.add(this.sldBar);
        this.getContentPane().add((Component)this.pnlBar, "First");
        this.pack();
    }

    private void btnOpenActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setAcceptAllFileFilterUsed(true);
        chooser.setDialogTitle("Select OGG file");
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        if (chooser.showOpenDialog(this) == 0) {
            this.btnStopActionPerformed(null);
            final File selected = chooser.getSelectedFile();
            OGGLoader loader = new OGGLoader();
            AudioKey key = new AudioKey(selected.getName(), true, true);
            try {
                this.musicData = (AudioData)loader.load(new AssetInfo(null, (AssetKey)key){

                    public InputStream openStream() {
                        try {
                            return new FileInputStream(selected);
                        }
                        catch (FileNotFoundException ex) {
                            ex.printStackTrace();
                            return null;
                        }
                    }
                });
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.musicSource = new AudioNode(this.musicData, key);
            this.musicLength = this.musicData.getDuration();
            this.updateTime();
        }
    }

    private void updateTime() {
        int max = (int)(this.musicLength * 100.0f);
        int pos = (int)(this.curTime * 100.0f);
        this.sldBar.setMaximum(max);
        this.sldBar.setValue(pos);
        int minutesTotal = (int)(this.musicLength / 60.0f);
        int secondsTotal = (int)(this.musicLength % 60.0f);
        int minutesNow = (int)(this.curTime / 60.0f);
        int secondsNow = (int)(this.curTime % 60.0f);
        String txt = String.format("%01d:%02d-%01d:%02d", minutesNow, secondsNow, minutesTotal, secondsTotal);
        this.lblTime.setText(txt);
    }

    private void btnPlayActionPerformed(ActionEvent evt) {
        if (this.musicSource == null) {
            this.btnOpenActionPerformed(evt);
            return;
        }
        if (this.musicSource.getStatus() == AudioNode.Status.Playing) {
            this.musicSource.setPitch(1.0f);
            this.ar.pauseSource(this.musicSource);
        } else {
            this.musicSource.setPitch(1.0f);
            this.musicSource.play();
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.ar.cleanup();
    }

    private void sldVolumeStateChanged(ChangeEvent evt) {
        this.listener.setVolume((float)this.sldVolume.getValue() / 100.0f);
        this.ar.setListener(this.listener);
    }

    private void btnStopActionPerformed(ActionEvent evt) {
        if (this.musicSource != null) {
            this.musicSource.setPitch(1.0f);
            this.ar.stopSource(this.musicSource);
        }
    }

    private void btnFFActionPerformed(ActionEvent evt) {
        if (this.musicSource.getStatus() == AudioNode.Status.Playing) {
            this.musicSource.setPitch(2.0f);
        }
    }

    private void sldBarStateChanged(ChangeEvent evt) {
        if (this.musicSource != null && !this.sldBar.getValueIsAdjusting()) {
            this.curTime = (float)this.sldBar.getValue() / 100.0f;
            if (this.curTime < 0.0f) {
                this.curTime = 0.0f;
            }
            this.musicSource.setTimeOffset(this.curTime);
            if (this.musicSource.getStatus() == AudioNode.Status.Playing) {
                this.musicSource.stop();
                this.musicSource.play();
            }
            this.updateTime();
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new TestMusicPlayer().setVisible(true);
            }
        });
    }
}

