/*
 * Decompiled with CFR 0.152.
 */
package jme3test.audio;

import com.jme3.app.SimpleApplication;
import com.jme3.audio.AudioNode;
import com.jme3.audio.Environment;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;

public class TestReverb
extends SimpleApplication {
    private AudioNode audioSource;
    private float time = 0.0f;
    private float nextTime = 1.0f;

    public static void main(String[] args) {
        TestReverb test = new TestReverb();
        test.start();
    }

    public void simpleInitApp() {
        this.audioSource = new AudioNode(this.assetManager, "Sound/Effects/Bang.wav");
        float[] eax = new float[]{15.0f, 38.0f, 0.3f, -1000.0f, -3300.0f, 0.0f, 1.49f, 0.54f, 1.0f, -2560.0f, 0.162f, 0.0f, 0.0f, 0.0f, -229.0f, 0.088f, 0.0f, 0.0f, 0.0f, 0.125f, 1.0f, 0.25f, 0.0f, -5.0f, 5000.0f, 250.0f, 0.0f, 63.0f};
        this.audioRenderer.setEnvironment(new Environment(eax));
        Environment env = Environment.Cavern;
        this.audioRenderer.setEnvironment(env);
    }

    public void simpleUpdate(float tpf) {
        this.time += tpf;
        if (this.time > this.nextTime) {
            Vector3f v = new Vector3f();
            v.setX(FastMath.nextRandomFloat());
            v.setY(FastMath.nextRandomFloat());
            v.setZ(FastMath.nextRandomFloat());
            v.multLocal(40.0f, 2.0f, 40.0f);
            v.subtractLocal(20.0f, 1.0f, 20.0f);
            this.audioSource.setLocalTranslation(v);
            this.audioSource.playInstance();
            this.time = 0.0f;
            this.nextTime = FastMath.nextRandomFloat() * 2.0f + 0.5f;
        }
    }
}

